% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{plot_mean_var}
\alias{plot_mean_var}
\alias{plot_mean_var,CEMiTool-method}
\title{Plot mean and variance}
\usage{
plot_mean_var(cem, ...)

\S4method{plot_mean_var}{CEMiTool}(cem, filter = FALSE)
}
\arguments{
\item{cem}{Object of class \code{CEMiTool}}

\item{...}{Optional parameters}

\item{filter}{Logical. Whether or not to use filtered data for CEMiTool objects (Default: FALSE).}
}
\value{
Object of class \code{CEMiTool} containing a mean and variance plot
}
\description{
This plot returns a scatterplot of the mean by the variance
of gene expression. A linear relationship between these values for
RNAseq data suggest that an appropriate transformation such as the
Variance Stabilizing Transformation should be applied.
}
\examples{
# Get example CEMiTool object
data(cem)
# Plot mean and variance plot
cem <- plot_mean_var(cem)
# Check results
show_plot(cem, 'mean_var')

}
