% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{get_connectivity}
\alias{get_connectivity}
\alias{get_connectivity,CEMiTool-method}
\title{Calculate network connectivity}
\usage{
get_connectivity(cem, ...)

\S4method{get_connectivity}{CEMiTool}(cem, beta)
}
\arguments{
\item{cem}{Object of class \code{CEMiTool} containing the fit_indices slot}

\item{...}{Optional parameters.}

\item{beta}{A soft-thresholding value to be used for the network.}
}
\value{
The value of the network's connectivity.
}
\description{
This function takes a CEMiTool object and returns the network connectivity.
}
\examples{
# Get example expression data
data(expr0)
# Initialize new CEMiTool object with expression data
cem <- new_cem(expr0, filter=TRUE, apply_vst=FALSE)
# Get modules and beta data
cem <- find_modules(cem)
# Get network connectivity with example beta value 8
get_connectivity(cem, beta=8)

}
