#' Yellow Fever gene expression data from GEO study GSE13485
#'
#' Modified data from a yellow fever vaccination study by Querec et al, 2009.
#' In order to reduce package size, only the 4000 genes with the highest 
#' variance were selected for this dataset. 
#'
#' @name expr0 
#' @docType data
#' @usage data(expr0)
#' @format An object of class \code{data.frame}
#' @keywords datasets
#' @references Querec TD, Akondy RS, Lee EK, Cao W et al. Systems biology 
#' approach predicts immunogenicity of the yellow fever vaccine in humans. 
#' Nat Immunol 2009 Jan;10(1):116-25. PMID: 19029902
#' \href{https://www.ncbi.nlm.nih.gov/pubmed/19029902}{PubMed}
#' @source \href{https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=gse13485}{GEO}
#' @examples
#' data(expr0)
#' # Run CEMiTool analysis
#' \dontrun{cemitool(expr0)}
"expr0"

#' Yellow Fever Sample Annotation data 
#'
#' Modified data from a yellow fever vaccination study by Querec et al, 
#' 2009. This dataset, together with \code{expr} can be used as input for 
#' CEMiTool functions
#'
#' @name sample_annot
#' @docType data
#' @usage data(sample_annot)
#' @format An object of class \code{data.frame} 
#' @keywords datasets
#' @references Querec TD, Akondy RS, Lee EK, Cao W et al. Systems biology 
#' approach predicts immunogenicity of the yellow fever vaccine in humans. 
#' Nat Immunol 2009 Jan;10(1):116-25. PMID: 19029902
#' \href{https://www.ncbi.nlm.nih.gov/pubmed/19029902}{PubMed}
#' @source \href{https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=gse13485}{GEO}
#' @examples
#' data(expr)
#' data(sample_annot)
#' # Run CEMiTool analysis
#' \dontrun{cemitool(expr, sample_annot)}
"sample_annot"

#' CEMiTool Object 
#'
#' This object can be used as input for CEMiTool functions. Data used are from 
#' \code{expr} and \code{sample_annot}.
#'
#' @name cem
#' @docType data
#' @usage data(cem)
#' @format An object of class \code{CEMiTool}
#' @keywords data
#' @examples
#' # Get example CEMiTool object
#' data(cem)
#' cem
"cem"



















