% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_sigmoid.R
\name{cc_sigmoid}
\alias{cc_sigmoid}
\title{Sigmoid Plot Function}
\usage{
cc_sigmoid(cc_df, n_top_ints = 20, colours = paletteMartin())
}
\arguments{
\item{cc_df}{A dataframe with columns 'source', 'target', 'ligand', 'receptor' and 'score'. See \code{toy_data} for example.}

\item{n_top_ints}{The number of top interactions to plot.}

\item{colours}{A named vector of colours for each cell type. Default is \code{paletteMartin()}, a colourblind-friendly palette.}
}
\value{
Returns a plot generated with the ggplot2 package
}
\description{
This function plots interactions using the \code{geom_sigmoid} function from the \code{ggbump} R package
}
\examples{
data(toy_data, package = 'CCPlotR')
cc_sigmoid(toy_data)
cc_sigmoid(toy_data, colours = c(
    `B` = "hotpink", `CD8 T` = "orange",
    `NK` = "cornflowerblue"
), n_top_ints = 25)

}
