% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bngeneplotCustom.R
\name{bngeneplotCustom}
\alias{bngeneplotCustom}
\title{bngeneplotCustom}
\usage{
bngeneplotCustom(
  results,
  exp,
  expSample = NULL,
  algo = "hc",
  R = 20,
  pathNum = NULL,
  convertSymbol = TRUE,
  expRow = "ENSEMBL",
  interactive = FALSE,
  cexCategory = 1,
  cl = NULL,
  showDir = FALSE,
  chooseDir = FALSE,
  algorithm.args = NULL,
  labelSize = 4,
  layout = "nicely",
  strType = "normal",
  returnNet = FALSE,
  otherVar = NULL,
  otherVarName = NULL,
  onlyDf = FALSE,
  disc = FALSE,
  tr = NULL,
  remainCont = NULL,
  dep = NULL,
  sizeDep = FALSE,
  orgDb = org.Hs.eg.db,
  bypassConverting = FALSE,
  edgeLink = FALSE,
  cellLineName = "5637_URINARY_TRACT",
  fontFamily = "sans",
  strengthPlot = FALSE,
  nStrength = 10,
  strThresh = NULL,
  hub = NULL,
  glowEdgeNum = NULL,
  nodePal = c("blue", "red"),
  edgePal = c("blue", "red"),
  textCol = "black",
  titleCol = "black",
  backCol = "white",
  barTextCol = "black",
  barPal = c("red", "blue"),
  barBackCol = "white",
  scoreType = "bic-g",
  barLegendKeyCol = "white",
  barAxisCol = "black",
  bg.colour = NULL,
  bg.r = 0.1,
  barPanelGridCol = "black",
  titleSize = 24,
  seed = 1
)
}
\arguments{
\item{results}{the enrichment analysis result}

\item{exp}{gene expression matrix}

\item{expSample}{candidate rows to be included in the inference
default to all}

\item{algo}{structure learning method used in boot.strength()
default to "hc"}

\item{R}{the number of bootstrap}

\item{pathNum}{the pathway number
(the number of row of the original result, ordered by p-value)}

\item{convertSymbol}{whether the label of resulting network is
converted to symbol, default to TRUE}

\item{expRow}{the type of the identifier of rows of expression matrix}

\item{interactive}{whether to use bnviewer (default to FALSE)}

\item{cexCategory}{scaling factor of size of nodes}

\item{cl}{cluster object from parallel::makeCluster()}

\item{showDir}{show the confidence of direction of edges}

\item{chooseDir}{if undirected edges are present, choose direction of edges}

\item{algorithm.args}{parameters to pass to 
bnlearn structure learnng function}

\item{labelSize}{the size of label of the nodes}

\item{layout}{ggraph layout, default to "nicely"}

\item{strType}{"normal" or "ms" for multiscale implementation}

\item{returnNet}{whether to return the network}

\item{otherVar}{other variables to be included in the inference}

\item{otherVarName}{the names of other variables}

\item{onlyDf}{return only data.frame used for inference}

\item{disc}{discretize the expressoin data}

\item{tr}{Specify data.frame if one needs to discretize
as the same parameters as the other dataset}

\item{remainCont}{Specify characters when perform discretization,
if some columns are to be remain continuous}

\item{dep}{the tibble storing dependency score from library depmap}

\item{sizeDep}{whether to reflect DepMap score to the node size}

\item{orgDb}{perform clusterProfiler::setReadable
based on this organism database}

\item{bypassConverting}{bypass the symbol converting
ID of rownames and those listed in EA result
must be same}

\item{edgeLink}{use geom_edge_link() instead of geom_edge_diagonal()}

\item{cellLineName}{the cell line name to be included}

\item{fontFamily}{font family name to be used for plotting}

\item{strengthPlot}{append the barplot depicting edges with high strength}

\item{nStrength}{specify how many edges are included in the strength plot}

\item{strThresh}{the threshold for strength}

\item{hub}{visualize the genes with top-n hub scores}

\item{glowEdgeNum}{edges with top-n confidence of direction are highlighted}

\item{nodePal}{vector of coloring of nodes (low, high)}

\item{edgePal}{vector of coloring of edges (low, high)}

\item{textCol}{color of texts in network plot}

\item{titleCol}{color of title in network plot}

\item{backCol}{color of background in network plot}

\item{barTextCol}{text color in barplot}

\item{barPal}{bar color}

\item{barBackCol}{background color in barplot}

\item{scoreType}{score type to use on inference}

\item{barLegendKeyCol}{legend key color in barplot}

\item{barAxisCol}{axis color in barplot}

\item{bg.colour}{parameter to pass to geom_node_text}

\item{bg.r}{parameter to pass to geom_node_text}

\item{barPanelGridCol}{panel grid color in barplot}

\item{titleSize}{the size of title}

\item{seed}{A random seed to make the analysis reproducible, default is 1.}
}
\value{
ggplot2 object
}
\description{
Plot gene relationship within the specified pathway using customized theme
}
\examples{
data("exampleEaRes");data("exampleGeneExp")
res <- bngeneplotCustom(results=exampleEaRes, exp=exampleGeneExp,
                        pathNum=1, glowEdgeNum=NULL, hub=3, R=40,
                        fontFamily="sans")
}
