% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guessPanel.R
\name{guessPanel}
\alias{guessPanel}
\title{Guess parameter panel}
\usage{
guessPanel(x, sep = "_")
}
\arguments{
\item{x}{a \code{\link[flowCore:flowFrame-class]{flowFrame}}.}

\item{sep}{character string specifying how channel descriptions 
should be parsed. E.g., if \code{pData(x)$desc} contains both 
channel and antigens formatted as, \code{155Gd_CD73}, 
descriptions will be split according to \code{sep} and 
everything after the first \code{sep} will be used as 
the antigen name (here, CD73).}
}
\value{
a \code{data.frame} with the following columns:
\itemize{
\item{\code{name}: the parameter name 
as extracted from the input \code{flowFrame},}
\item{\code{desc}: the parameter description 
as extracted from the input \code{flowFrame},}
\item{\code{antigen}: the targeted protein markers, and}
\item{\code{use_channel}: logical. If TRUE, the channel 
is expected to contain a marker and will be kept.}}
}
\description{
Helper function to parse information from the 
  \code{parameters} slot of a \code{flowFrame}/\code{flowSet}.
}
\examples{
# examplary data with Time, DNA, BC channels, etc.
data(raw_data)
guessPanel(raw_data[[1]])

}
\author{
Mark D Robinson &
Helena L Crowell \email{helena.crowell@uzh.ch}
}
