% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CAGEfightR.R
\name{quickEnhancers}
\alias{quickEnhancers}
\alias{quickEnhancers,CAGEexp-method}
\title{Identify and quantify enhancers.}
\usage{
quickEnhancers(object)

\S4method{quickEnhancers}{CAGEexp}(object)
}
\arguments{
\item{object}{A \code{CAGEexp} object}
}
\value{
A \code{RangedSummarizedExperiment} object.  See the example below on
how to attach it to the experiment list of a \code{CAGEexp} object.
}
\description{
A convenient wrapper to the function \code{\link[CAGEfightR:quickEnhancers]{CAGEfightR::quickEnhancers()}}.
}
\details{
The \code{CAGEr} object will be converted to a format similar to the output
of \code{\link[CAGEfightR:quantifyCTSSs]{CAGEfightR::quantifyCTSSs()}}, and then passed to the \code{quickEnhancers}
function.
}
\examples{
# Can not run as long as the test data has nothing on the minus strand!
\dontrun{
quickEnhancers(exampleCAGEexp)
}

}
\seealso{
Other CAGEr object modifiers: 
\code{\link{CTSStoGenes}()},
\code{\link{CustomConsensusClusters}()},
\code{\link{aggregateTagClusters}()},
\code{\link{annotateCTSS}()},
\code{\link{cumulativeCTSSdistribution}()},
\code{\link{distclu}()},
\code{\link{getCTSS}()},
\code{\link{normalizeTagCount}()},
\code{\link{paraclu}()},
\code{\link{quantilePositions}()},
\code{\link{resetCAGEexp}()},
\code{\link{summariseChrExpr}()}
}
\author{
Charles Plessy

Katalin Ferenc
}
\concept{CAGEfightR}
\concept{CAGEr object modifiers}
