% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorrelationMethods.R
\name{plotCorrelation}
\alias{plotCorrelation}
\alias{plotCorrelation,CAGEr-method}
\alias{plotCorrelation2}
\alias{plotCorrelation2,CAGEexp-method}
\alias{plotCorrelation2,SummarizedExperiment-method}
\alias{plotCorrelation2,DataFrame-method}
\alias{plotCorrelation2,data.frame-method}
\alias{plotCorrelation2,matrix-method}
\alias{correlationMatrix}
\alias{correlationMatrix,CAGEexp-method}
\alias{correlationMatrix,SummarizedExperiment-method}
\alias{correlationMatrix,DataFrame-method}
\alias{correlationMatrix,data.frame-method}
\alias{correlationMatrix,matrix-method}
\title{Pairwise scatter plots and correlations of CAGE signal}
\usage{
plotCorrelation(
  object,
  what = c("CTSS", "consensusClusters"),
  values = c("raw", "normalized"),
  samples = "all",
  method = "pearson",
  tagCountThreshold = 1,
  applyThresholdBoth = FALSE,
  plotSize = 800
)

\S4method{plotCorrelation}{CAGEr}(
  object,
  what = c("CTSS", "consensusClusters"),
  values = c("raw", "normalized"),
  samples = "all",
  method = "pearson",
  tagCountThreshold = 1,
  applyThresholdBoth = FALSE,
  plotSize = 800
)

plotCorrelation2(
  object,
  what = c("CTSS", "consensusClusters"),
  values = c("raw", "normalized"),
  samples = "all",
  method = "pearson",
  tagCountThreshold = 1,
  applyThresholdBoth = FALSE,
  digits = 3
)

\S4method{plotCorrelation2}{CAGEexp}(
  object,
  what = c("CTSS", "consensusClusters"),
  values = c("raw", "normalized"),
  samples = "all",
  method = "pearson",
  tagCountThreshold = 1,
  applyThresholdBoth = FALSE,
  digits = 3
)

\S4method{plotCorrelation2}{SummarizedExperiment}(
  object,
  what = c("CTSS", "consensusClusters"),
  values = c("raw", "normalized"),
  samples = "all",
  method = "pearson",
  tagCountThreshold = 1,
  applyThresholdBoth = FALSE,
  digits = 3
)

\S4method{plotCorrelation2}{DataFrame}(
  object,
  what = c("CTSS", "consensusClusters"),
  values = c("raw", "normalized"),
  samples = "all",
  method = "pearson",
  tagCountThreshold = 1,
  applyThresholdBoth = FALSE,
  digits = 3
)

\S4method{plotCorrelation2}{data.frame}(
  object,
  what = c("CTSS", "consensusClusters"),
  values = c("raw", "normalized"),
  samples = "all",
  method = "pearson",
  tagCountThreshold = 1,
  applyThresholdBoth = FALSE,
  digits = 3
)

\S4method{plotCorrelation2}{matrix}(
  object,
  what = c("CTSS", "consensusClusters"),
  values = c("raw", "normalized"),
  samples = "all",
  method = "pearson",
  tagCountThreshold = 1,
  applyThresholdBoth = FALSE,
  digits = 3
)

correlationMatrix(
  object,
  what = c("CTSS", "consensusClusters"),
  values = c("raw", "normalized"),
  samples = "all",
  method = "pearson",
  tagCountThreshold = 1,
  applyThresholdBoth = FALSE
)

\S4method{correlationMatrix}{CAGEexp}(
  object,
  what = c("CTSS", "consensusClusters"),
  values = c("raw", "normalized"),
  samples = "all",
  method = "pearson",
  tagCountThreshold = 1,
  applyThresholdBoth = FALSE
)

\S4method{correlationMatrix}{SummarizedExperiment}(
  object,
  what = c("CTSS", "consensusClusters"),
  values = c("raw", "normalized"),
  samples = "all",
  method = "pearson",
  tagCountThreshold = 1,
  applyThresholdBoth = FALSE
)

\S4method{correlationMatrix}{DataFrame}(
  object,
  what = c("CTSS", "consensusClusters"),
  values = c("raw", "normalized"),
  samples = "all",
  method = "pearson",
  tagCountThreshold = 1,
  applyThresholdBoth = FALSE
)

\S4method{correlationMatrix}{data.frame}(
  object,
  what = c("CTSS", "consensusClusters"),
  values = c("raw", "normalized"),
  samples = "all",
  method = "pearson",
  tagCountThreshold = 1,
  applyThresholdBoth = FALSE
)

\S4method{correlationMatrix}{matrix}(
  object,
  what = c("CTSS", "consensusClusters"),
  values = c("raw", "normalized"),
  samples = "all",
  method = "pearson",
  tagCountThreshold = 1,
  applyThresholdBoth = FALSE
)
}
\arguments{
\item{object}{A \code{\link{CAGEexp}} object or a \code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment::SummarizedExperiment}}
or an expression table as a \code{\link[S4Vectors:DataFrame-class]{S4Vectors::DataFrame}}, \code{\link{data.frame}} or
\code{\link{matrix}} object. \code{\link[=plotCorrelation]{plotCorrelation()}} only supports \code{CAGEexp} input.}

\item{what}{The clustering level to be used for plotting and calculating
correlations: \code{CTSS} (individual TSSs) or \code{consensusClusters}. Ignored for
anything else than \code{CAGEexp} and \code{SummarizedExperiment} objects.}

\item{values}{Use either \code{raw} (default) or \code{normalized} CAGE
signal.  Ignored for plain expression tables.}

\item{samples}{Character vector indicating which samples to use.  Can be
either \code{all} to select all samples in a \code{CAGEexp} object, or a subset of
valid sample labels as returned by \code{\link[=sampleLabels]{sampleLabels()}}.}

\item{method}{A character string indicating which correlation coefficient
should be computed.  Passed to \code{\link[=cor]{cor()}}.  Can be one of \code{pearson},
\code{spearman}, or \code{kendall}.}

\item{tagCountThreshold, applyThresholdBoth}{Only TSSs with tag count
\verb{>= tagCountThreshold} in either one (\code{applyThresholdBoth = FALSE}) or both
samples (\code{applyThresholdBoth = TRUE}) are plotted and used to calculate
correlation.}

\item{plotSize}{Size of the individual comparison plot in pixels - the
total size of the resulting png will be \code{length(samples) * plotSize}
in both dimensions.  Ignored in \code{plotCorrelation2}.}

\item{digits}{The number of significant digits for the data to be kept in log
scale.  Ignored in \code{plotCorrelation}.  In \code{plotCorrelation2}, the
number of points plotted is considerably reduced by rounding the point
coordinates to a small number of significant digits before removing
duplicates.  Chose a value that makes the plot visually indistinguishable
with non-deduplicated data, by making tests on a subset of the data.}
}
\value{
Displays the plot and returns a \code{matrix} of pairwise
correlations between selected samples.  The scatterplots of
\code{plotCorrelation} are colored according to the density of points, and
in \code{plotCorrelation2} they are just black and white, which is much
faster to plot.  Note that while the scatterplots are on a logarithmic scale
with pseudocount added to the zero values, the correlation coefficients are
calculated on untransformed (but thresholded) data.

\code{correlationMatrix()} returns a \code{matrix} of pairwise correlations
between selected samples.
}
\description{
Functions to compute pairwise sample correlations and display them in a
matrix with scatter plots below the diagonal, sample names on the diagonal,
and correlation coefficients above.
}
\details{
In the scatter plots, a pseudo-count equal to half the lowest score
is added to the null values so that they can appear despite logarithmic scale.

\code{SummarizedExperiment} objects are expected to contain raw tag counts in a
\code{counts} assay and the normalized expression scores in a \code{normalized} assay.

Avoid using large \code{matrix} objects as they are coerced to \code{DataFrame} class
without special care for efficiency.

\code{plotCorrelation2} speeds up the plotting by a) deduplicating
that data: no point is plot twice at the same coordinates, b) rounding the
data so that indistinguishable positions are plotted only once, c) using a
black square glyph for the points, d) caching some calculations that are
made repeatedly (to determine where to plot the correlation coefficients),
and e) preventing coercion of \code{DataFrames} to \code{data.frames}.
}
\examples{

plotCorrelation2(exampleCAGEexp, what = "consensusClusters", value = "normalized")

correlationMatrix(exampleCAGEexp, what = "consensusClusters", value = "normalized")

}
\seealso{
Other CAGEr plot functions: 
\code{\link{TSSlogo}()},
\code{\link{hanabiPlot}()},
\code{\link{plotAnnot}()},
\code{\link{plotExpressionProfiles}()},
\code{\link{plotInterquantileWidth}()},
\code{\link{plotReverseCumulatives}()}
}
\author{
Vanja Haberle

Charles Plessy

Katalin Ferenc
}
\concept{CAGEr plot functions}
