% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImportMethods.R
\name{moleculesGR2CTSS}
\alias{moleculesGR2CTSS}
\title{moleculesGR2CTSS}
\usage{
moleculesGR2CTSS(gr)
}
\arguments{
\item{gr}{A \link[GenomicRanges:GRanges-class]{GenomicRanges::GRanges} object.}
}
\value{
Returns a \link[GenomicRanges:GRanges-class]{GenomicRanges::GRanges} object.
}
\description{
Calculates CTSS positions from a GenomicRanges object where each element
represents a single molecule.
}
\examples{
gr <- GenomicRanges::GRanges("chr1", IRanges::IRanges(1, 10), c("+", "-", "+"))
CAGEr:::moleculesGR2CTSS(gr)
}
\seealso{
Other loadFileIntoGPos: 
\code{\link{bam2CTSS}()},
\code{\link{import.CTSS}()},
\code{\link{import.bam}()},
\code{\link{import.bam.ctss}()},
\code{\link{import.bedCTSS}()},
\code{\link{import.bedScore}()},
\code{\link{import.bedmolecule}()},
\code{\link{import.bigwig}()},
\code{\link{loadFileIntoGPos}()}
}
\concept{loadFileIntoGPos}
