% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShiftingMethods.R
\name{getShiftingPromoters}
\alias{getShiftingPromoters}
\alias{getShiftingPromoters,CAGEexp-method}
\title{Select consensus clusters with shifting score above threshold}
\usage{
getShiftingPromoters(
  object,
  groupX,
  groupY,
  tpmThreshold = 0,
  scoreThreshold = -Inf,
  fdrThreshold = 1
)

\S4method{getShiftingPromoters}{CAGEexp}(
  object,
  groupX,
  groupY,
  tpmThreshold = 0,
  scoreThreshold = -Inf,
  fdrThreshold = 1
)
}
\arguments{
\item{object}{A \code{\link{CAGEexp}} object.}

\item{groupX, groupY}{Character vector of the one or more CAGE dataset labels in the first
(\code{groupX}) and in the second group (\code{groupY}). Shifting promoters for the specified
group pair are returned.}

\item{tpmThreshold}{Consensus clusters with total CAGE signal \code{>= tpmThreshold}
in each of the compared groups will be returned.}

\item{scoreThreshold}{Consensus clusters with shifting score \code{>= scoreThreshold}
will be returned. The default value \code{-Inf} returns all consensus clusters
(for which score could be calculated, \emph{i.e.} the ones that have at least
one tag in each of the compared samples).}

\item{fdrThreshold}{Consensus clusters with adjusted P-value (FDR) from
Kolmogorov-Smirnov test \code{>= fdrThreshold} will be returned. The default
value \code{1} returns all consensus clusters (for which K-S test could be
performed, \emph{i.e.} the ones that have at least one tag in each of the
compared samples).}
}
\value{
Returns a \code{data.frame} of shifting promoters with genomic coordinates and
positions of dominant TSS and CAGE signal in the two compared (groups of) samples, along
with shifting score and adjusted P-value (FDR).
}
\description{
Extracts consensus clusters with shifting score and/or FDR (adjusted P-value from
Kolmogorov-Smirnov test) above specified threshold. Returns their genomic coordinates,
total CAGE signal and the position of dominant TSS in the two compared groups of CAGE
samples, along with the value of the shifting score, P-value and FDR.  Scores and
P-values/FDR have to be calculated beforehand by calling \code{\link{scoreShift}} function.
}
\examples{
getShiftingPromoters( exampleCAGEexp
                    , groupX = "Zf.unfertilized.egg"
                    , groupY = "Zf.30p.dome") |> head()

}
\seealso{
Other CAGEr promoter shift functions: 
\code{\link{scoreShift}()}
}
\author{
Vanja Haberle

Sarvesh Nikumbh
}
\concept{CAGEr promoter shift functions}
