% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CumulativeDistributionMethods.R
\name{cumulativeCTSSdistribution}
\alias{cumulativeCTSSdistribution}
\alias{cumulativeCTSSdistribution,CAGEexp-method}
\title{Cumulative sums of CAGE counts along genomic regions}
\usage{
cumulativeCTSSdistribution(
  object,
  clusters = c("tagClusters", "consensusClusters"),
  useMulticore = FALSE,
  nrCores = NULL
)

\S4method{cumulativeCTSSdistribution}{CAGEexp}(
  object,
  clusters = c("tagClusters", "consensusClusters"),
  useMulticore = FALSE,
  nrCores = NULL
)
}
\arguments{
\item{object}{A \code{\link{CAGEr}} object}

\item{clusters}{\code{tagClusters} or \code{consensusClusters}.}

\item{useMulticore}{Logical, should multicore be used.
\code{useMulticore = TRUE} has no effect on non-Unix-like platforms.}

\item{nrCores}{Number of cores to use when \code{useMulticore = TRUE}
(set to \code{NULL} to use all detected cores).}
}
\value{
In \code{CAGEexp} objects, cumulative sums for the \emph{tag clusters} are
stored in the metadata slot using the \code{RleList} class.  For \emph{consensus
clusters}, they are stored in \emph{assays} of the \code{consensusClusters} experiment
slot of the \code{CAGEexp} object.
}
\description{
Calculates the cumulative sum of normalised CAGE counts along each tag
cluster or consensus cluster in every sample within a CAGEr object.
}
\examples{
cumulativeCTSSdistribution(exampleCAGEexp, clusters = "tagClusters")
CTSScumulativesTagClusters(exampleCAGEexp)[[1]][1:6]
cumulativeCTSSdistribution(exampleCAGEexp, clusters = "consensusClusters")
CTSScumulativesCC(exampleCAGEexp)[[1]][1:6]
           
}
\seealso{
Other CAGEr object modifiers: 
\code{\link{CTSStoGenes}()},
\code{\link{CustomConsensusClusters}()},
\code{\link{aggregateTagClusters}()},
\code{\link{annotateCTSS}()},
\code{\link{distclu}()},
\code{\link{getCTSS}()},
\code{\link{normalizeTagCount}()},
\code{\link{paraclu}()},
\code{\link{quantilePositions}()},
\code{\link{quickEnhancers}()},
\code{\link{resetCAGEexp}()},
\code{\link{summariseChrExpr}()}

Other CAGEr clusters functions: 
\code{\link{CTSScumulativesTagClusters}()},
\code{\link{CustomConsensusClusters}()},
\code{\link{aggregateTagClusters}()},
\code{\link{consensusClustersDESeq2}()},
\code{\link{consensusClustersGR}()},
\code{\link{distclu}()},
\code{\link{paraclu}()},
\code{\link{plotInterquantileWidth}()},
\code{\link{quantilePositions}()},
\code{\link{tagClustersGR}()}
}
\author{
Vanja Haberle

Charles Plessy
}
\concept{CAGEr clusters functions}
\concept{CAGEr object modifiers}
