% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CTSS.R
\docType{class}
\name{CTSS-class}
\alias{CTSS-class}
\alias{show,CTSS-method}
\alias{initialize,CTSS-method}
\alias{CTSS}
\alias{coerce,CTSS,GRanges-method}
\alias{coerce,GRanges,CTSS-method}
\title{CAGE Transcription Start Sites}
\usage{
\S4method{show}{CTSS}(object)

\S4method{initialize}{CTSS}(.Object, ..., bsgenomeName = NULL)

CTSS(
  seqnames = NULL,
  pos = NULL,
  strand = NULL,
  ...,
  seqinfo = NULL,
  seqlengths = NULL,
  bsgenomeName = NULL
)

\S4method{coerce}{CTSS,GRanges}(from, to = "GRanges", strict = TRUE)

\S4method{coerce}{GRanges,CTSS}(from, to = "CTSS", strict = TRUE)
}
\arguments{
\item{object}{See  \code{\link[methods:show]{methods::show}}}

\item{.Object}{See  \code{\link[methods:new]{methods::new}}}

\item{bsgenomeName}{String containing the name of a \emph{BSgenome} package.}

\item{seqnames, pos, strand, seqinfo, seqlengths, ...}{See the documentation
of \code{\link[GenomicRanges:GPos-class]{GenomicRanges::GPos}} for further details.}

\item{from, to, strict}{See  \code{\link[methods:setAs]{methods::coerce}}.}
}
\description{
The \code{CTSS} class represents CAGE transcription start sites (CTSS) at
single-nucleotide resolution, using \code{\link[GenomicRanges:GPos-class]{GenomicRanges::UnstitchedGPos}} as base
class.  It is used by \emph{CAGEr} for type safety.

The \code{CTSS} constructor takes the same arguments as \code{\link[GenomicRanges:GPos-class]{GenomicRanges::GPos}},
plus \code{bsgenomeName}, and minus \code{stitch}, which is hardcoded to \code{FALSE}.
}
\details{
The \code{genomeName} element of the \code{metadata} slot is used to store the
name of the \emph{BSgenome} package used when constructing the \code{CAGEr} object.

Coercion from \code{GRanges} to \code{CTSS} loses information, but it seems
to be fine, since other coercions like \code{as(1.2, "integer")} do the same.
}
\examples{
# Convert an UnstitchedGPos object using the new() constructor.
gp <- GPos("chr1:2:-", stitch = FALSE)
ctss <- new("CTSS", gp, bsgenomeName = "BSgenome.Drerio.UCSC.danRer7")
genomeName(ctss)

# Create a new object using the CTSS() constructor.
CTSS("chr1", 2, "-", bsgenomeName = "BSgenome.Drerio.UCSC.danRer7")

# Coerce CTSS to GRanges
as(ctss, "GRanges")

# Coerce a GRanges object to CTSS using the as() method.
gr <- GRanges("chr1:1-10:-")
gr$seq <- "AAAAAAAAAA"
seqlengths(gr) <- 100
genome(gr) <- "foo"
as(gr, "CTSS")
identical(seqinfo(gr), seqinfo(as(gr, "CTSS")))
as(as(gr, "CTSS"), "CTSS") # Make sure it works twice in a row
}
\author{
Charles Plessy
}
