% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign.R
\name{assignTxType}
\alias{assignTxType}
\alias{assignTxType,GenomicRanges,GenomicRangesList-method}
\alias{assignTxType,RangedSummarizedExperiment,GenomicRangesList-method}
\alias{assignTxType,GenomicRanges,TxDb-method}
\alias{assignTxType,RangedSummarizedExperiment,TxDb-method}
\title{Annotate ranges with transcript type.}
\usage{
assignTxType(object, txModels, ...)

\S4method{assignTxType}{GenomicRanges,GenomicRangesList}(
  object,
  txModels,
  outputColumn = "txType",
  swap = NULL,
  noOverlap = "intergenic"
)

\S4method{assignTxType}{RangedSummarizedExperiment,GenomicRangesList}(object, txModels, ...)

\S4method{assignTxType}{GenomicRanges,TxDb}(
  object,
  txModels,
  outputColumn = "txType",
  swap = NULL,
  tssUpstream = 100,
  tssDownstream = 100,
  proximalUpstream = 1000,
  detailedAntisense = FALSE
)

\S4method{assignTxType}{RangedSummarizedExperiment,TxDb}(object, txModels, ...)
}
\arguments{
\item{object}{GRanges or RangedSummarizedExperiment: Ranges to be annotated.}

\item{txModels}{TxDb or GRangesList: Transcript models via a TxDb, or
manually specified as a GRangesList.}

\item{...}{additional arguments passed to methods.}

\item{outputColumn}{character: Name of column to hold txType values.}

\item{swap}{character or NULL: If not NULL, use another set of ranges
contained in object to calculate overlaps, for example peaks in the thick
column.}

\item{noOverlap}{character: In case categories are manually supplied with as
a GRangesList, what to call regions with no overlap.}

\item{tssUpstream}{integer: Distance to extend annotated promoter upstream.}

\item{tssDownstream}{integer: Distance to extend annotated promoter
downstream.}

\item{proximalUpstream}{integer: Maximum distance upstream of promoter to be
considered proximal.}

\item{detailedAntisense}{logical: Wether to mirror all txType categories in
the antisense direction (TRUE) or lump them all together (FALSE).}
}
\value{
object with txType added as factor column in rowData (or mcols)
}
\description{
Annotate a set of ranges in a GRanges object with transcript type (txType)
based on their genic context. Transcripts are obtained from a TxDb object,
but can alternatively be specified manually as a GRangesList.
}
\examples{
\dontrun{
data(exampleUnidirectional)

# Obtain transcript models from a TxDb-object:
library(TxDb.Mmusculus.UCSC.mm9.knownGene)
txdb <- TxDb.Mmusculus.UCSC.mm9.knownGene

# Assign txIDs
assignTxType(exampleUnidirectional,
             txModels=txdb)

# Assign txIDs using only TC peaks:
exampleUnidirectional <- assignTxType(exampleUnidirectional,
                                      txModels=txdb,
                                      swap='thick')

# The 'promoter' and 'proximal' category boundaries can be changed:
assignTxType(exampleUnidirectional,
             txModels=txdb,
             swap='thick',
             tssUpstream=50,
             tssDownstream=50,
             proximalUpstream=100)

# Annotation using complete antisense categories:
exampleUnidirectional <- assignTxType(exampleUnidirectional,
                                    txModels=txdb,
                                    outputColumn='txTypeExtended',
                                    swap='thick',
                                    detailedAntisense=TRUE)

# The output is always a factor added as a column:
summary(rowRanges(exampleUnidirectional)$txType)
summary(rowRanges(exampleUnidirectional)$txTypeExtended)

# To avoid using a TxDb-object, a GRangesList can be supplied:
custom_hierarchy <- GRangesList(promoters=granges(promoters(txdb)),
                                exons=granges(exons(txdb)))
assignTxType(exampleUnidirectional,
             txModels=custom_hierarchy,
             outputColumn='customType',
             swap='thick',
             noOverlap = 'intergenic')
}
}
\seealso{
Other Annotation functions: 
\code{\link{assignGeneID}()},
\code{\link{assignMissingID}()},
\code{\link{assignTxID}()}
}
\concept{Annotation functions}
