% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cellTypeAssign.R
\name{summarizedCellularNetwork}
\alias{summarizedCellularNetwork}
\title{Build a summary cellular network}
\usage{
summarizedCellularNetwork(tab)
}
\arguments{
\item{tab}{The data.frame output by \code{"\link{cellularNetworkTable}"}.}
}
\value{
A igraph object containing a summary cellular network with
edge weights proportional to the sum of individual link scores. Edge
weight are normalized to a total of one.
}
\description{
Generate a igraph object with one link between each cell type.
}
\examples{
data(bsrdm, package = "BulkSignalR")
data(bsrinf, package = "BulkSignalR")
data("tme.signatures", package = "BulkSignalR")
data(immune.signatures, package = "BulkSignalR")

immune.signatures <- immune.signatures[immune.signatures$signature \%in\%
    c("T cells"), ]

signatures <- rbind(immune.signatures, tme.signatures[
    tme.signatures$signature \%in\% c("Fibroblasts"),
])

tme.scores <- scoreSignatures(bsrdm, signatures)

# assignment
lr2ct <- assignCellTypesToInteractions(bsrdm, bsrinf, tme.scores)

# cellular network
g.table <- cellularNetworkTable(lr2ct[c(1:25),])
gSummary <- summarizedCellularNetwork(g.table)
# plot(gSummary, edge.width=1+30*E(gSummary)$score)
}
