% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regulatedInference.R
\name{.checkRegulatedReceptorSignaling}
\alias{.checkRegulatedReceptorSignaling}
\title{Internal function to check receptor signaling downstream}
\usage{
.checkRegulatedReceptorSignaling(
  ds,
  cc,
  lr,
  reference = c("REACTOME-GOBP", "REACTOME", "GOBP"),
  pos.targets = FALSE,
  neg.targets = FALSE,
  min.t.logFC = 0.5,
  use.full.network = FALSE,
  max.pw.size = 400,
  min.pw.size = 5,
  min.positive = 2,
  restrict.pw = NULL,
  with.complex = TRUE
)
}
\arguments{
\item{ds}{An optional BSRDataModel object.}

\item{cc}{A BSRClusterComp object.}

\item{lr}{A table as returned by \code{.getRegulatedLR()}.}

\item{reference}{Which pathway reference should be used ("REACTOME"
for Reactome, "GOBP" for GO Biological Process,
or "REACTOME-GOBP" for both).}

\item{pos.targets}{A logical imposing that all the network targets must
display positive logFC, i.e. logFC >= min.t.logFC.}

\item{neg.targets}{A logical imposing that all the network targets must
display negative logFC, i.e. logFC <= - min.t.logFC.}

\item{min.t.logFC}{The minimum log2 fold-change allowed for
targets in case pos.targets or neg.targets are used.}

\item{use.full.network}{A logical to avoid limiting the reference network
to the detected genes and use the whole reference network.}

\item{max.pw.size}{Maximum pathway size to consider from the pathway
reference.}

\item{min.pw.size}{Minimum pathway size to consider from the pathway
reference.}

\item{min.positive}{Minimum number of target genes to be found in a given
pathway.}

\item{restrict.pw}{A list of pathway IDs to restrict the application of
the function.}

\item{with.complex}{A logical indicating whether receptor co-complex
members should be included in the target genes.}
}
\value{
A data frame extending \code{lr} content with the pathways found to
contain the receptors and data about receptor target gene regulations
Strings in semi-colon-separated format are used to report
target genes and their regulation P-values in the
data frame. The target genes are sorted according to the P-values in
decreasing order.

In case \code{ds} is set, then correlations between the receptor and
target genes will be computed for documentation or additional use. The
row names of \code{differentialStats(cc)} and \code{ncounts(ds)} must match
exactly (not necessarily in the same order). The same is true for
\code{differentialStats(scc)} in case \code{scc} is provided.

In a pathway of the reference, i.e., a Reactome pathway or the genes of a
GOBP term, the target genes are the
genes coding for proteins forming a complex with the receptor and the
genes in the pathway downstream the receptor,
which are given as regulated by the pathway. If \code{with.complex} is
set to \code{FALSE}, then only the
regulated genes are considered. Participation to a complex and being
regulated as well as the pathway directed topologies
are defined by Reactome and KEGG pathways as provided by PathwayCommons.

The maximum pathway size is used to limit the redundancy inherent to GOBP
and Reactome. The minimum pathway size is
used to avoid overspecific, noninformative results.
}
\description{
Assess the existence of concomitant regulations between a receptor,
part of a ligand-receptor pair, and
genes coding for proteins forming a complex with the receptor or genes
regulated by the receptor downstream signaling.
}
\keyword{internal}
