% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataPrepare.R
\name{convertToHuman}
\alias{convertToHuman}
\title{Transpose to Human Gene Names}
\usage{
convertToHuman(counts, dictionary)
}
\arguments{
\item{counts}{A table or matrix of read counts.}

\item{dictionary}{A data frame where the first column 
is made of gene symbols for the actual organism 
and row names are the ortholog human gene symbols.}
}
\value{
Return a counts matrix transposed for Human.
}
\description{
By default, BulkSignalR is designed to work with Homo sapiens.
In order to work with other organisms, gene names need to be first converted
to human by orthology.
}
\examples{
data(bodyMap.mouse)

idx <- sample(nrow(bodyMap.mouse), 500)
bodyMap.mouse <- bodyMap.mouse[idx,]

ortholog.dict <- findOrthoGenes(
    from_organism = "mmusculus",
    from_values = rownames(bodyMap.mouse)
)

matrix.expression.human <- convertToHuman(
    counts = bodyMap.mouse,
    dictionary = ortholog.dict
)

}
