% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cellTypeAssign.R
\name{cellularNetwork}
\alias{cellularNetwork}
\title{Build a cellular network}
\usage{
cellularNetwork(tab)
}
\arguments{
\item{tab}{The data.frame output by \code{"\link{cellularNetworkTable}"}.}
}
\value{
A igraph object containing all the links in the cellular network.
}
\description{
Generate a igraph object including all the links between cell types.
}
\examples{
data(bsrdm, package = "BulkSignalR")
data(bsrinf, package = "BulkSignalR")
data("tme.signatures", package = "BulkSignalR")
data(immune.signatures, package = "BulkSignalR")

immune.signatures <- immune.signatures[immune.signatures$signature \%in\%
    c("T cells"), ]

signatures <- rbind(immune.signatures, tme.signatures[
    tme.signatures$signature \%in\% c("Fibroblasts"),
])

tme.scores <- scoreSignatures(bsrdm, signatures)

# assignment
lr2ct <- assignCellTypesToInteractions(bsrdm, bsrinf, tme.scores)

# cellular network
g.table <- cellularNetworkTable(lr2ct)
gCN <- cellularNetwork(g.table)

#plot(gCN, edge.width=5*E(gCN)$score)
}
