% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BrowserViz-class.R
\name{BrowserViz constructor}
\alias{BrowserViz constructor}
\alias{BrowserViz}
\title{Constructor for BrowserViz}
\usage{
BrowserViz(
  host = "localhost",
  portRange = 10000:10100,
  title = "BrowserViz",
  browserFile,
  quiet = TRUE,
  httpQueryProcessingFunction = NULL
)
}
\arguments{
\item{host}{character The constructor will open an http/websocket port here for web browsers to connect to.  localhost by default}

\item{portRange}{The constructor looks for a free websocket port in this range.  10000:10100 by default}

\item{title}{Used for the web browser window, "igvR" by default}

\item{browserFile}{The full path to the bundled html, js and libraries, and css which constitute the browser app}

\item{quiet}{A logical variable controlling verbosity during execution}

\item{httpQueryProcessingFunction}{a function, default NULL, provides subclasses with the
opportunity to execute code on the http server created here.}
}
\value{
An object of the BrowserViZ class
}
\description{
This constructor function:

\itemize{
  \item creates the BrowserViz object
  \item initializes the httpuv web server
  \item prepares that web server to additionally handle websocket traffic
  \item loads a "browserFile" - an html/javascript/css web page to communicate with in your web browser
  \item opens websocket communication between your R session and your browser
  \item installs an optional "httpQueryProcessingFunction" to handle http (non-websocket) requests.
}
}
