% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/saveIndex.R
\name{saveIndex}
\alias{saveIndex}
\alias{saveIndex,BiocNeighborGenericIndex-method}
\title{Save a nearest-neighbor index}
\usage{
saveIndex(BNINDEX, dir, ...)

\S4method{saveIndex}{BiocNeighborGenericIndex}(BNINDEX, dir, ...)
}
\arguments{
\item{BNINDEX}{A \linkS4class{BiocNeighborIndex} object representing a pre-built index, typically from \code{\link{buildIndex}}.}

\item{dir}{String containing the path to a directory in which to save the index.
This directory should already exist.}

\item{...}{Further arguments to pass to specific methods.}
}
\value{
One or more files are created on disk inside \code{dir}.
These can be used to reconstitute \code{BNINDEX} by calling \code{\link{loadIndex}}.
}
\description{
Save an index for nearest-neighbor searching to disk.
}
\details{
Files generated by \code{saveIndex} are not guaranteed to be portable across architectures, compilers, or even versions of \pkg{BiocNeighbors}.
An index saved in this manner is only intended to be read back to the same R environment on the same machine.
}
\examples{
Y <- matrix(rnorm(100000), ncol=20)
k.out <- buildIndex(Y)

tmp <- tempfile()
dir.create(tmp)
saveIndex(k.out, tmp)
list.files(tmp, recursive=TRUE)

}
\author{
Aaron Lun
}
