% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/queryDistance.R
\name{queryDistanceFromIndex}
\alias{queryDistanceFromIndex}
\alias{queryDistance}
\alias{queryDistanceFromIndex,BiocNeighborGenericIndex-method}
\title{Distance to the k-th nearest neighbor to query points}
\usage{
queryDistanceFromIndex(
  BNINDEX,
  query,
  k,
  num.threads = 1,
  subset = NULL,
  transposed = FALSE,
  ...
)

\S4method{queryDistanceFromIndex}{BiocNeighborGenericIndex}(
  BNINDEX,
  query,
  k,
  num.threads = 1,
  subset = NULL,
  transposed = FALSE,
  ...,
  .check.nonfinite = TRUE
)

queryDistance(
  X,
  query,
  k,
  num.threads = 1,
  ...,
  subset = NULL,
  transposed = FALSE,
  BNPARAM = NULL
)
}
\arguments{
\item{BNINDEX}{A \linkS4class{BiocNeighborIndex} object, typically created by \code{\link{buildIndex}}.}

\item{query}{A numeric matrix or matrix-like object of query points, containing the same number of columns as \code{X}.}

\item{k}{A positive integer scalar specifying the number of nearest neighbors to retrieve.

Alternatively, an integer vector of length equal to the number of points in \code{query}, specifying the number of neighbors to identify for each point.
If \code{subset} is provided, this should have length equal to the length of \code{subset}.
Users should wrap this vector in an \link{AsIs} class to distinguish length-1 vectors from integer scalars.

All \code{k} should be less than or equal to the number of points in \code{X}, otherwise the former will be capped at the latter with a warning.}

\item{num.threads}{Integer scalar specifying the number of threads to use for the search.}

\item{subset}{An integer, logical or character vector indicating the rows of \code{query} (or columns, if \code{transposed=TRUE}) for which the nearest neighbors should be identified.}

\item{transposed}{A logical scalar indicating whether \code{query} is transposed, in which case it contains dimensions in the rows and data points in the columns.
For \code{queryKNN}, settting \code{transposed=TRUE} also indicates that \code{X} is also transposed.}

\item{...}{For \code{queryDistanceFromIndex}, further arguments to pass to individual methods.
If a method accepts arguments here, it should prefix these arguments with the algorithm name to avoid conflicts, e.g., \code{vptree.foo.bar}.

For \code{queryDistance}, further arguments to pass to \code{queryDistanceFromIndex}.
These are also passed to \code{\link{buildIndex}} when \code{X} is not an external pointer.}

\item{.check.nonfinite}{Boolean indicating whether to check for non-finite values in \code{query}.
This can be set to \code{FALSE} for greater efficiency.}

\item{X}{The reference dataset to be queried.
This should be a numeric matrix or matrix-like object where rows correspond to reference points and columns correspond to variables (i.e., dimensions).
Alternatively, a prebuilt \linkS4class{BiocNeighborIndex} object from \code{\link{buildIndex}}.}

\item{BNPARAM}{A \linkS4class{BiocNeighborParam} object specifying how the index should be constructed.
If \code{NULL}, this defaults to a \linkS4class{KmknnParam}.
Ignored if \code{X} contains a prebuilt index.}
}
\value{
Numeric vector of length equal to the number of points in \code{query} (or \code{subset}, if provided),
containing the distance from each point to its \code{k}-th nearest neighbor.
This is equivalent to but more memory efficient than using \code{\link{queryKNN}} and subsetting to the last distance.
}
\description{
Query a reference dataset to determine the distance to the k-th nearest neighbor of each point in a query dataset.
}
\details{
If multiple queries are to be performed to the same \code{X}, it may be beneficial to build the index from \code{X} with \code{\link{buildIndex}}.
The resulting pointer object can be supplied as \code{X} to multiple \code{queryKNN} calls, avoiding the need to repeat index construction in each call.
}
\examples{
Y <- matrix(rnorm(100000), ncol=20)
Z <- matrix(rnorm(20000), ncol=20)
out <- queryDistance(Y, query=Z, k=5)
head(out)

}
\seealso{
\code{\link{buildIndex}}, to build an index ahead of time.
}
\author{
Aaron Lun
}
