% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadIndex.R
\name{loadIndex}
\alias{loadIndex}
\title{Load a prebuilt search index from disk}
\usage{
loadIndex(dir, ...)
}
\arguments{
\item{dir}{String containing the path to a directory in which the original index was saved.
This should be the same as the argument passed to \code{\link{saveIndex}}.}

\item{...}{Additional arguments passed to specific methods.}
}
\value{
A \linkS4class{BiocNeighborIndex} object, created from files inside \code{dir}.
}
\description{
Load a \linkS4class{BiocNeighborIndex} object from its on-disk representation back into the current R session.
}
\details{
As discussed in \code{\link{saveIndex}}, it is expected that the on-disk representation is loaded in the same R environment that was used to save it.

Developers are directed to \code{\link{getLoadGenericIndexRegistry}} to add loading functions for their own search algorithms.
}
\examples{
Y <- matrix(rnorm(100000), ncol=20)
k.out <- buildIndex(Y)
k.nn <- findKNN(k.out, k=5)

tmp <- tempfile()
dir.create(tmp)
saveIndex(k.out, tmp)

reloaded <- loadIndex(tmp)
re.nn <- findKNN(reloaded, k=5)
identical(k.nn, re.nn)

}
\author{
Aaron Lun
}
