% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadIndex.R
\name{getLoadGenericIndexRegistry}
\alias{getLoadGenericIndexRegistry}
\alias{registerLoadGenericIndexClass}
\alias{registerLoadIndexFunction}
\title{Load indices from extension packages}
\usage{
getLoadGenericIndexRegistry()

registerLoadGenericIndexClass(name, class)

registerLoadIndexFunction(name, fun)
}
\arguments{
\item{name}{String containing the name of the neighbor search algorithm, e.g., \code{"knncolle::Vptree"}.}

\item{class}{Function that accepts a single argument (the external pointer to a \code{knncolle::Prebuilt} instance)
and returns an instance of the appropriate \linkS4class{BiocNeighborGenericIndex} subclass.}

\item{fun}{Function that accepts a directory path (see \code{\link{loadIndex}}) plus any number of additional arguments via \code{...},
and returns an instance of the \linkS4class{BiocNeighborIndex} subclass corresponding to \code{name}.}
}
\value{
For \code{getLoadGenericIndexRegistry}, an external pointer to the global \code{knncolle::load_prebuilt_registry()} object in C++.

For \code{registerLoadGenericIndexClass}, the name and class are registered with \code{loadIndex}.

For \code{registerLoadIndexFunction}, the name and function are registered with \code{loadIndex}.
}
\description{
Extend \code{\link{loadIndex}} to work with algorithms from \pkg{BiocNeighbors} extension packages.
}
\details{
If the extension developer implements their search algorithm in the form of C++ subclasses of the various \pkg{knncolle} interfaces,
they can call \code{getLoadGenericIndexRegistry} in their package's \code{\link{.onLoad}} to access the registry and add a loading method for their algorithm.
They should also call \code{registerLoadGenericIndexClass} to specify a constructor function for the corresponding \linkS4class{BiocNeighborGenericIndex} subclass.

If the extension developer implements their search algorithm by subclassing \pkg{BiocNeighbors} generics at the R level,
they should call \code{registerLoadIndexFunction} in their package's \code{\link{.onLoad}}.
This function is responsible for reading the on-disk contents from the specified directory and using them to construct a \linkS4class{BiocNeighborIndex} instance.
}
\examples{
getLoadGenericIndexRegistry()
registerLoadGenericIndexClass("knncolle_annoy::Annoy", AnnoyIndex)

}
\author{
Aaron Lun
}
