% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeBiocFileCacheFromDataFrame.R
\name{makeBiocFileCacheFromDataFrame}
\alias{makeBiocFileCacheFromDataFrame}
\alias{makeBiocFileCacheFromDataFrame,ANY-method}
\title{Make BiocFileCache objects from an existing data.frame}
\usage{
makeBiocFileCacheFromDataFrame(
  df,
  cache,
  actionLocal = c("move", "copy", "asis"),
  actionWeb = c("move", "copy"),
  metadataName,
  ...,
  ask = TRUE
)

\S4method{makeBiocFileCacheFromDataFrame}{ANY}(
  df,
  cache,
  actionLocal = c("move", "copy", "asis"),
  actionWeb = c("move", "copy"),
  metadataName,
  ...,
  ask = TRUE
)
}
\arguments{
\item{df}{data.frame or tibble to convert}

\item{cache}{character(1) On-disk location (directory path) of
cache. For default location see
\code{\link[tools]{R_user_dir}}.}

\item{actionLocal}{If local copy of file should be moved, copied or
left in original location. See 'action' param of bfcadd.}

\item{actionWeb}{If a local copy of a remote resource already
exists, should the file be copied or moved to the
cache. Locally downloaded remote resources must exist in the
cache location.}

\item{metadataName}{If there are additional columns of data in the
original data.frame besides required BiocFileCache columns,
this data will be added as a metadata table with this name.}

\item{...}{additional arguments passed to `file.copy()`.}

\item{ask}{logical(1) Confirm creation of BiocFileCache.}
}
\value{
A BiocFileCache object
}
\description{
If there are a lot of resources being added this could take some
time but if a cache is saved in a permanent location this should
only have to be run once. The original data.frame must have the
required columns 'rtype', 'fpath', and 'rpath'; See the vignette
for more information on the expected information contained in these
columns. Similarly, the optional columns 'rname', 'etag',
'last_modified_time', and 'expires' may be included. Any additional columns
not listed as required or optional will be kept as an additional
metadata table in the BiocFileCache database.
}
\examples{
## Create a data.frame with the required columns
tempf <- tempfile(fileext = ".txt")
file.create(tempf)
df <- data.frame(
    rtype = "local",
    fpath = tempf,
    rpath = tempf,
    rname = "Example File 1",
    etag = "etag1",
    last_modified_time = as.character(Sys.Date()),
    expires = as.character(Sys.Date() + 1),
    stringsAsFactors = FALSE
)
## Create a BiocFileCache from the data.frame
bfc <- makeBiocFileCacheFromDataFrame(
    df, cache = tempfile(), actionLocal = "move",
    metadataName = "resourceMetadata", ask = FALSE
)
bfc
bfcinfo(bfc)
removebfc(bfc, ask = FALSE)

}
