% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Message-class.R
\docType{class}
\name{Message-class}
\alias{Message-class}
\alias{.MessageCondition}
\alias{setMessage,Message-method}
\alias{setCondition,Message-method}
\alias{getCondition,Message-method}
\title{A lower level Message helper class for BiocCheck}
\arguments{
\item{condition}{\code{character(1)} One of the three conditions handled: \code{error},
\code{warning}, or \code{note}}

\item{\dots}{\code{list()} A nested list with the check name as the top level
layer. Second level lists include any \code{help_text} and \code{messages} that are
part of the check.}
}
\value{
\code{.MessageCondition}: An internal \code{R5} Reference Class to handle
messages and their conditions, e.g., for errors, warnings, or notes.
}
\description{
A lower level Message helper class for BiocCheck
}
\section{Fields}{

\describe{
\item{\code{msg}}{\code{list()} A list of character messages usually grown with \code{append}
with conditions raised by a check}

\item{\code{condition}}{\code{character(1)} One of the three conditions handled: \code{error},
\code{warning}, or \code{note}}
}}


\section{methods}{

\itemize{
\item \code{setMessage}: Set the message and condition (\code{error}, \code{warning}, or
\code{note}) for the check
\item \code{setCondition}: Change the condition for the check
\item \code{getCondition}: Get the condition from the \code{Message} class
}
}

\seealso{
\link{BiocCheck-class} \link{BiocPackage-class}
}
\keyword{internal}
