% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifecycle.R
\name{lifeCycle}
\alias{lifeCycle}
\title{Set the life cycle stage of a function}
\usage{
lifeCycle(
  newfun = oldfun,
  newpackage,
  package,
  cycle = c("deprecated", "defunct"),
  title = package
)
}
\arguments{
\item{newfun}{\code{character(1)} The name of the function to use instead. It can
be a specific function within another package (e.g., \verb{package::function})
or a function in the current package (e.g., \code{function}). If \code{newfun} is not
specified, the calling function \code{oldfun} is assumed to be the replacement.}

\item{newpackage}{\code{character(1)} If a function is moved to a new package, the
name of the new package can be specified here. This is equivalent to
specifying \code{newfun = paste0(newpackage, "::", newfun)}.}

\item{package}{\code{character(1)} The name of the package where the deprecated
or defunct function resides. It corresponds to the package from where the
\code{lifeCycle} function is called.}

\item{cycle}{\code{character(1)} The life cycle stage of the function. This can be
either \code{"deprecated"} or \code{"defunct"}.}

\item{title}{\code{character(1)} The Rd name prefix of the documentation page
where deprecated or defunct functions are documented (e.g., "summary" for
"summary-deprecated"). By default, the package name is used.}
}
\description{
The \code{lifeCycle} function is used to set the life cycle stage of
a function. It is to be used within the body of the function that is being
deprecated or defunct. It is a wrapper around both \code{.Deprecated} and
\code{.Defunct} base R functions.
}
\examples{
test_fun <- function() {
    lifeCycle(newfun = "new_test", package = "BiocBaseUtils")
}
## catch warning and convert to message
tryCatch(test_fun(), warning = function(w) message(w))

test_fun <- function() {
    lifeCycle(
        newfun = "new_test", package = "BiocBaseUtils", cycle = "defunct"
    )
}
## catch error and convert to message
tryCatch(test_fun(), error = function(e) message(e))
}
