% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preprocess.R
\name{replace_na}
\alias{replace_na}
\title{Remove missing values in a gene expression data frame}
\usage{
replace_na(exp, replaceby = 0)
}
\arguments{
\item{exp}{A gene expression data frame with genes in row names and
samples in column names or a `SummarizedExperiment` object.}

\item{replaceby}{What to use instead of NAs. One of 0 or 'mean'. Default is 0.}
}
\value{
Gene expression data frame or `SummarizedExperiment` object
with all NAs replaced according to the argument 'replaceby'.
}
\description{
Remove missing values in a gene expression data frame
}
\examples{
data(zma.se)
exp <- replace_na(zma.se)
sum(is.na(exp))
}
\author{
Fabricio Almeida-Silva
}
