% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcn_inference.R
\name{plot_module_trait_cor}
\alias{plot_module_trait_cor}
\title{Plot a heatmap of module-trait correlations}
\usage{
plot_module_trait_cor(corandp, palette = "RdYlBu", transpose = FALSE)
}
\arguments{
\item{corandp}{A data frame of module-trait correlations as returned
by \code{module_trait_cor()}.}

\item{palette}{Character indicating which RColorBrewer palette to use.
Default: 'RdYlBu'.}

\item{transpose}{Logical indicating whether to transpose the heatmap
or not.}
}
\value{
A `Heatmap` object created by \code{ComplexHeatmap::pheatmap()}.
}
\description{
Plot a heatmap of module-trait correlations
}
\details{
Significance levels:
1 asterisk: significant at alpha = 0.05.
2 asterisks: significant at alpha = 0.01.
3 asterisks: significant at alpha = 0.001.
no asterisk: not significant.
}
\examples{
data(filt.se)
gcn <- exp2gcn(filt.se, SFTpower = 18, cor_method = "pearson")
corandp <- module_trait_cor(filt.se, MEs = gcn$MEs)
plot_module_trait_cor(corandp)
}
