% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{recluster}
\alias{recluster}
\title{Hierarchical graph clustering}
\usage{
recluster(GG, ALGN, CnMAX, weights = NULL)
}
\arguments{
\item{GG}{graph to cluster}

\item{ALGN}{algorithm to apply}

\item{CnMAX}{maximum size of the cluster in \code{mem} that will not be
processed}

\item{weights}{The weights of the edges. It must be a positive numeric
vector, NULL or NA. If it is NULL and the input graph has a ‘weight’
edge attribute, then that attribute will be used. If NULL and no such
attribute is present, then the edges will have equal weights. Set
this to NA if the graph was a ‘weight’ edge attribute, but you don't
want to use it for community detection. A larger edge weight means a
stronger connection for this function. The weights value is ignored
for the \code{spectral} clustering.}
}
\value{
remembership matrix, that contains vertex ID membership and
result of reclustering
}
\description{
Function reads in a graph \code{GG} with cluster membership stored in vertex
attribute \code{ALGN}, and reapplies the clustering algorithm \code{ALGN} to
all clusters larger than \code{CnMAX}
}
\examples{
data(karate,package='igraphdata')
alg<-'louvain'
mem<-calcMembership(karate,alg = alg)
remem<-calcReclusterMatrix(karate,mem,alg,10)
}
