% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneSim.R
\name{geneSim}
\alias{geneSim}
\alias{geneSim,character,character,GeneSetCollection-method}
\title{Similarity score genes based on pathways similarity}
\usage{
geneSim(gene1, gene2, info, method = "max", ...)

\S4method{geneSim}{character,character,GeneSetCollection}(gene1, gene2, info, method = "max", ...)
}
\arguments{
\item{gene1, gene2}{Ids of the genes to calculate the similarity, to be found
in genes.}

\item{info}{A GeneSetCollection or a list of genes and the pathways they are
involved.}

\item{method}{one of \code{c("avg", "max", "rcmax", "rcmax.avg", "BMA", "reciprocal")}, see Details.}

\item{...}{Other arguments passed to \code{combineScores}}
}
\value{
The highest Dice score of all the combinations of pathways between
the two ids compared if a method to combine scores is provided or NA if
there isn't information for one gene.
If an \code{NA} is returned this means that there isn't information
available for any pathways for one of the genes. Otherwise a number
between 0 and 1 (both included) is returned. Note that there isn't a
negative value of similarity.
}
\description{
Given two genes, calculates the Dice similarity between each pathway
which is combined to obtain a similarity between the genes.
}
\details{
Given the information about the genes and their pathways, uses the ids
of the genes to find the Dice similarity score for each pathway comparison
between the genes. Later this similarities are combined using
\code{\link[=combineScoresPar]{combineScoresPar()}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{geneSim(gene1 = character, gene2 = character, info = GeneSetCollection)}: Calculates all the similarities of the GeneSetCollection
and combine them using \code{\link[=combineScoresPar]{combineScoresPar()}}

}}
\examples{
if (require("org.Hs.eg.db") & require("reactome.db")) {
    # Extract the paths of all genes of org.Hs.eg.db from KEGG
    # (last update in data of June 31st 2011)
    genes.kegg <- as.list(org.Hs.egPATH)
    # Extracts the paths of all genes of org.Hs.eg.db from reactome
    genes.react <- as.list(reactomeEXTID2PATHID)
    geneSim("81", "18", genes.react)
    geneSim("81", "18", genes.kegg)
    geneSim("81", "18", genes.react, NULL)
    geneSim("81", "18", genes.kegg, NULL)
} else {
    warning("You need reactome.db and org.Hs.eg.db package for this example")
}
}
\seealso{
\code{\link[=mgeneSim]{mgeneSim()}}, \code{\link[=conversions]{conversions()}} help page to transform Dice
score to Jaccard score. For the method to combine the scores see
\code{\link[=combineScoresPar]{combineScoresPar()}}.
}
\author{
Lluís Revilla
}
