% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\docType{methods}
\name{setSignal}
\alias{setSignal}
\alias{setSignal,BSFDataSet-method}
\title{Setter method for the signal data of the BSFDataSet object}
\usage{
setSignal(object, ...)

\S4method{setSignal}{BSFDataSet}(object, newSignal, dropSeqlevels = TRUE, quiet = FALSE)
}
\arguments{
\item{object}{a BSFDataSet object}

\item{...}{additional arguments}

\item{newSignal}{list of RLE lists}

\item{dropSeqlevels}{enforce seqnames to be the same in ranges and signal,
by dropping unused seqlevels which is required for most downstream functions
such as \code{coverageOverRanges}}

\item{quiet}{logical; whether to print messages}
}
\value{
an object of type \code{\link{BSFDataSet}} with updated signal
}
\description{
Signal data is loaded from the path specified in \code{\link{getMeta}}
columns "clPlus" and "clMinus" and stored as a list of RLE lists.
}
\examples{

# load data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))

sgn = getSignal(bds)
sgn = lapply(sgn, function(selStrand){
   lapply(selStrand, function(chrList){
       chrList[names(chrList) == "chr22"]
   })
})
bdsNew = setSignal(bds, sgn)

}
\seealso{
\code{\link{BSFDataSet}}
}
