% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knee_plot.R
\name{get_knee_df}
\alias{get_knee_df}
\alias{get_inflection}
\alias{knee_plot}
\title{Plot the transposed knee plot and inflection point}
\usage{
get_knee_df(mat)

get_inflection(df, lower = 100)

knee_plot(df, inflection)
}
\arguments{
\item{mat}{Gene count matrix, a dgCMatrix.}

\item{df}{The data frame from \code{\link{get_knee_df}}.}

\item{lower}{Minimum total UMI counts for barcode for it to be considered
when calculating the inflection point; this helps to avoid the noisy part of
the curve for barcodes with very few counts.}

\item{inflection}{Output of \code{\link{get_inflection}}.}
}
\value{
\code{get_knee_df} returns a tibble with two columns: \code{total} for
total UMI counts for each barcode, and \code{rank} for rank of the total
counts, with number 1 for the barcode with the most counts.

\code{get_inflection} returns a \code{numeric(1)} for the total UMI count
at the inflection point.

\code{knee_plot} returns a \code{ggplot2} object.
}
\description{
Plot a transposed knee plot, showing the inflection point and
the number of remaining cells after inflection point filtering. It's
transposed since it's more generalizable to multi-modal data.
}
\note{
Code in part adapted from \code{barcodeRanks} from \code{DropetUtils}.
}
\examples{
# Download dataset already in BUS format
library(TENxBUSData)
TENxBUSData(".", dataset = "hgmm100")
tr2g <- transcript2gene(c("Homo sapiens", "Mus musculus"), 
  ensembl_version = 99, kallisto_out_path = "./out_hgmm100")
m <- make_sparse_matrix("./out_hgmm100/output.sorted.txt",
  tr2g = tr2g, est_ncells = 1e5,
  est_ngenes = nrow(tr2g), TCC = FALSE)
df <- get_knee_df(m)
infl <- get_inflection(df)
knee_plot(df, infl)
# Clean up files from the example
unlink("out_hgmm100")
}
