% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/velocity.R
\name{annot_circular}
\alias{annot_circular}
\title{Transfer information about circular chromosomes between genome and annotation}
\usage{
annot_circular(Genome, annot)
}
\arguments{
\item{Genome}{Either a \code{\link{BSgenome}} or a \code{\link{XStringSet}}
object of genomic sequences, where the intronic sequences will be extracted
from. Use \code{\link{genomeStyles}} to check which styles are supported for
your organism of interest; supported styles can be interconverted. If the
style in your genome or annotation is not supported, then the style of
chromosome names in the genome and annotation should be manually set to be
consistent.}

\item{annot}{Genome annotation, an object of a class with a
\code{\link{seqlevels}} method, such as \code{GRanges}, \code{TxDb}, and \code{EnsDb}.}
}
\value{
If neither genome nor annotation indicates which chromosome is
circular, then the input will be returned unchanged. If only one of genome
and annotation has such information, then it will be transferred to the one
that does not. If both do have such information, the information from the
genome will be transferred to the annotation if they're different.
}
\description{
Internal use, called after calling \code{\link{subset_annot}}.
}
