#' gdepoch
#'
#' @keywords internal
#'
#' @description Run a gradient descent epoch (L and R are starting points,
#' gamma is stgammaize)
#'
#' @return a list containing two matrices generated by the gradient descent for
#' the current epoch
gdepoch <- function(L, R, lambda, gamma, is, js, D,
                    error_matrix = NULL) {
  if (is.null(error_matrix)) {
    error_matrix <- (D - L %*% R)
  }

  locLoss <- localLoss(L, R, is, js, error_matrix)

  ## perform a gradient step on L and R with step size gamma
  ## by using the gradient matrices


  L <- L + gamma * 2 * (locLoss$dL - lambda * L)
  R <- R + gamma * 2 * (locLoss$dR - lambda * R)



  ## return result
  return(list(L = L, R = R))
}
