% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcSummary.R
\name{calcSummary}
\alias{calcSummary}
\title{Summarize median comparison and p-value calculation results}
\usage{
calcSummary(medians, pvalues, mediansTreshold, pvaluesTreshold)
}
\arguments{
\item{medians}{a matrix containing median difference values calculated by
the \code{\link{calcBatchEffects}} function. For further details look at the
documentation of this function.}

\item{pvalues}{a matrix containing p-values calculated by the
\code{\link{calcBatchEffects}} function. For further details look at the
documentation of this function.}

\item{mediansTreshold}{the threshold above or equal median values are regarded 
as batch effected, when the criteria for p-values is also met.}

\item{pvaluesTreshold}{the threshold below or equal p-values are regarded as 
batch effected, when the criteria for medians is also met.}
}
\value{
Null if there are no batch effects detected, else
a \code{\link[data.table]{data.table}} with the columns "gene" containing the gene name,
"batch" containing the batch number from which the gene was found, "median"
and "p-value" containing the calculated median difference values and the
p-values, respectively.
}
\description{
Summarizes the results of the \code{\link{calcBatchEffects}} 
function
}
\details{
calcSummary

All genes with a median comparison value >= 0.05 and a p-value
of <= 0.01 are summarized into a data.frame. These genes are assumed to
contain a batch effect
}
\examples{
## Shortly running example. For a more realistic example that takes
## some more time, run the same procedure with the full BEclearData
## dataset.

## Whole procedure that has to be done to use this function.
data(BEclearData)
ex.data <- ex.data[31:90, 7:26]
ex.samples <- ex.samples[7:26, ]

## Calculate the batch effects
batchEffects <- calcBatchEffects(data = ex.data, samples = ex.samples,
adjusted = TRUE, method = "fdr")
med <- batchEffects$med
pvals <- batchEffects$pval

## Summarize p-values and median differences for batch affected genes
sum <- calcSummary(medians = med, pvalues = pvals)
}
\seealso{
\code{\link{calcBatchEffects}}

\code{\link{correctBatchEffect}}
}
