% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_Data.R
\name{format_DF}
\alias{format_DF}
\title{Format the data as expected by BERT.}
\usage{
format_DF(
  data,
  labelname = "Label",
  batchname = "Batch",
  referencename = "Reference",
  samplename = "Sample",
  covariatename = NULL,
  assayname = NULL
)
}
\arguments{
\item{data}{Matrix or dataframe in the format (samples, features).}

\item{labelname}{A string containing the name of the column to use as class
labels. The default is "Label".}

\item{batchname}{A string containing the name of the column to use as batch
labels. The default is "Batch".}

\item{referencename}{A string containing the name of the column to use as ref.
labels. The default is "Reference".}

\item{samplename}{A string containing the name of the column to use as sample
name. The default is "Sample".}

\item{covariatename}{A vector containing the names of columns with
categorical covariables. The default is NULL, for which all columns with
the pattern "Cov" will be selected.
Additional column names are "Batch", "Cov_X" (were X may be any number),
"Label" and "Sample".}

\item{assayname}{User-defined string that specifies, which assay to select,
if the input data is a SummarizedExperiment. The default is NULL.}
}
\value{
The formatted matrix.
}
\description{
This function is called automatically by BERT. It removes empty columns
and removes a (usually very small) number of numeric values, if features are
unadjustable for lack of data.
}
