// Generated by rstantools.  Do not edit by hand.

/*
    BASiCStan is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BASiCStan is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BASiCStan.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_basics_regression_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 98> locations_array__ =
  {" (found before start of program)",
  " (in 'basics_regression', line 54, column 2 to column 20)",
  " (in 'basics_regression', line 55, column 2 to column 29)",
  " (in 'basics_regression', line 56, column 2 to column 18)",
  " (in 'basics_regression', line 57, column 2 to column 29)",
  " (in 'basics_regression', line 58, column 2 to column 25)",
  " (in 'basics_regression', line 59, column 2 to column 29)",
  " (in 'basics_regression', line 60, column 2 to column 18)",
  " (in 'basics_regression', line 61, column 2 to column 22)",
  " (in 'basics_regression', line 62, column 2 to column 30)",
  " (in 'basics_regression', line 65, column 2 to column 59)",
  " (in 'basics_regression', line 66, column 2 to column 38)",
  " (in 'basics_regression', line 67, column 2 to column 40)",
  " (in 'basics_regression', line 68, column 2 to column 70)",
  " (in 'basics_regression', line 69, column 2 to column 39)",
  " (in 'basics_regression', line 72, column 2 to column 32)",
  " (in 'basics_regression', line 73, column 2 to column 25)",
  " (in 'basics_regression', line 74, column 2 to column 33)",
  " (in 'basics_regression', line 75, column 2 to column 43)",
  " (in 'basics_regression', line 76, column 2 to column 30)",
  " (in 'basics_regression', line 77, column 2 to column 35)",
  " (in 'basics_regression', line 78, column 2 to column 46)",
  " (in 'basics_regression', line 79, column 2 to column 20)",
  " (in 'basics_regression', line 80, column 2 to column 58)",
  " (in 'basics_regression', line 82, column 4 to line 85, column 6)",
  " (in 'basics_regression', line 86, column 4 to column 48)",
  " (in 'basics_regression', line 81, column 17 to line 87, column 3)",
  " (in 'basics_regression', line 81, column 2 to line 87, column 3)",
  " (in 'basics_regression', line 29, column 2 to column 8)",
  " (in 'basics_regression', line 30, column 2 to column 8)",
  " (in 'basics_regression', line 31, column 2 to column 9)",
  " (in 'basics_regression', line 32, column 2 to column 8)",
  " (in 'basics_regression', line 33, column 8 to column 9)",
  " (in 'basics_regression', line 33, column 11 to column 12)",
  " (in 'basics_regression', line 33, column 2 to column 34)",
  " (in 'basics_regression', line 34, column 8 to column 10)",
  " (in 'basics_regression', line 34, column 12 to column 13)",
  " (in 'basics_regression', line 34, column 2 to column 35)",
  " (in 'basics_regression', line 35, column 2 to column 10)",
  " (in 'basics_regression', line 36, column 2 to column 10)",
  " (in 'basics_regression', line 37, column 2 to column 14)",
  " (in 'basics_regression', line 38, column 2 to column 14)",
  " (in 'basics_regression', line 39, column 10 to column 11)",
  " (in 'basics_regression', line 39, column 13 to column 14)",
  " (in 'basics_regression', line 39, column 2 to column 29)",
  " (in 'basics_regression', line 40, column 10 to column 11)",
  " (in 'basics_regression', line 40, column 2 to column 18)",
  " (in 'basics_regression', line 41, column 9 to column 10)",
  " (in 'basics_regression', line 41, column 2 to column 18)",
  " (in 'basics_regression', line 42, column 2 to column 11)",
  " (in 'basics_regression', line 43, column 2 to column 13)",
  " (in 'basics_regression', line 44, column 2 to column 13)",
  " (in 'basics_regression', line 45, column 2 to column 8)",
  " (in 'basics_regression', line 46, column 10 to column 11)",
  " (in 'basics_regression', line 46, column 2 to column 19)",
  " (in 'basics_regression', line 47, column 9 to column 10)",
  " (in 'basics_regression', line 47, column 12 to column 13)",
  " (in 'basics_regression', line 47, column 2 to column 21)",
  " (in 'basics_regression', line 48, column 2 to column 20)",
  " (in 'basics_regression', line 49, column 9 to column 14)",
  " (in 'basics_regression', line 49, column 2 to column 19)",
  " (in 'basics_regression', line 50, column 2 to column 11)",
  " (in 'basics_regression', line 51, column 10 to column 12)",
  " (in 'basics_regression', line 51, column 2 to column 27)",
  " (in 'basics_regression', line 54, column 10 to column 11)",
  " (in 'basics_regression', line 55, column 20 to column 21)",
  " (in 'basics_regression', line 56, column 10 to column 11)",
  " (in 'basics_regression', line 57, column 8 to column 9)",
  " (in 'basics_regression', line 58, column 20 to column 21)",
  " (in 'basics_regression', line 59, column 20 to column 21)",
  " (in 'basics_regression', line 60, column 10 to column 11)",
  " (in 'basics_regression', line 62, column 20 to column 21)",
  " (in 'basics_regression', line 65, column 20 to column 21)",
  " (in 'basics_regression', line 66, column 20 to column 21)",
  " (in 'basics_regression', line 67, column 20 to column 21)",
  " (in 'basics_regression', line 68, column 10 to column 11)",
  " (in 'basics_regression', line 69, column 10 to column 11)",
  " (in 'basics_regression', line 9, column 4 to column 11)",
  " (in 'basics_regression', line 10, column 12 to column 13)",
  " (in 'basics_regression', line 10, column 15 to column 16)",
  " (in 'basics_regression', line 10, column 4 to column 20)",
  " (in 'basics_regression', line 11, column 4 to column 39)",
  " (in 'basics_regression', line 14, column 8 to column 20)",
  " (in 'basics_regression', line 13, column 21 to line 15, column 7)",
  " (in 'basics_regression', line 13, column 6 to line 15, column 7)",
  " (in 'basics_regression', line 12, column 19 to line 16, column 5)",
  " (in 'basics_regression', line 12, column 4 to line 16, column 5)",
  " (in 'basics_regression', line 17, column 4 to column 20)",
  " (in 'basics_regression', line 19, column 13 to column 14)",
  " (in 'basics_regression', line 19, column 6 to column 20)",
  " (in 'basics_regression', line 21, column 8 to column 43)",
  " (in 'basics_regression', line 20, column 21 to line 22, column 7)",
  " (in 'basics_regression', line 20, column 6 to line 22, column 7)",
  " (in 'basics_regression', line 23, column 6 to column 47)",
  " (in 'basics_regression', line 18, column 25 to line 24, column 5)",
  " (in 'basics_regression', line 18, column 4 to line 24, column 5)",
  " (in 'basics_regression', line 25, column 4 to column 14)",
  " (in 'basics_regression', line 8, column 6 to line 26, column 3)"};
template <typename T1__, typename T2__, typename T3__,
          stan::require_all_t<stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_col_vector<T3__>,
                              stan::is_vt_not_complex<T3__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T1__>, T2__,
                stan::base_type_t<T3__>>,-1,-1>
designMatrix(const int& l, const T1__& log_mu_arg__, const T2__&
             rbf_variance, const T3__& ml_arg__, const int& q, std::ostream*
             pstream__);
template <typename T1__, typename T2__, typename T3__,
          stan::require_all_t<stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_col_vector<T3__>,
                              stan::is_vt_not_complex<T3__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T1__>, T2__,
                stan::base_type_t<T3__>>,-1,-1>
designMatrix(const int& l, const T1__& log_mu_arg__, const T2__&
             rbf_variance, const T3__& ml_arg__, const int& q, std::ostream*
             pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T1__>,
                             T2__, stan::base_type_t<T3__>>;
  int current_statement__ = 0;
  const auto& log_mu = stan::math::to_ref(log_mu_arg__);
  const auto& ml = stan::math::to_ref(ml_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    local_scalar_t__ h = DUMMY_VAR__;
    current_statement__ = 78;
    stan::math::validate_non_negative_index("X", "q", q);
    current_statement__ = 79;
    stan::math::validate_non_negative_index("X", "l", l);
    Eigen::Matrix<local_scalar_t__,-1,-1> X =
      Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(q, l, DUMMY_VAR__);
    current_statement__ = 81;
    h = ((stan::model::rvalue(ml, "ml", stan::model::index_uni(2)) -
      stan::model::rvalue(ml, "ml", stan::model::index_uni(1))) *
      rbf_variance);
    current_statement__ = 86;
    for (int i = 1; i <= q; ++i) {
      current_statement__ = 84;
      for (int j = 1; j <= l; ++j) {
        current_statement__ = 82;
        stan::model::assign(X, 1, "assigning variable X",
          stan::model::index_uni(i), stan::model::index_uni(j));
      }
    }
    current_statement__ = 87;
    stan::model::assign(X, log_mu, "assigning variable X",
      stan::model::index_omni(), stan::model::index_uni(2));
    current_statement__ = 95;
    for (int i = 1; i <= (l - 2); ++i) {
      current_statement__ = 88;
      stan::math::validate_non_negative_index("tmp", "q", q);
      Eigen::Matrix<local_scalar_t__,-1,1> tmp =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(q, DUMMY_VAR__);
      current_statement__ = 92;
      for (int j = 1; j <= q; ++j) {
        current_statement__ = 90;
        stan::model::assign(tmp,
          stan::math::pow(
            (stan::model::rvalue(log_mu, "log_mu", stan::model::index_uni(j))
            - stan::model::rvalue(ml, "ml", stan::model::index_uni(i))), 2),
          "assigning variable tmp", stan::model::index_uni(j));
      }
      current_statement__ = 93;
      stan::model::assign(X,
        stan::math::exp(
          stan::math::divide(stan::math::multiply(-0.5, tmp),
            stan::math::pow(h, 2))), "assigning variable X",
        stan::model::index_omni(), stan::model::index_uni((i + 2)));
    }
    current_statement__ = 96;
    return X;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_basics_regression final : public model_base_crtp<model_basics_regression> {
private:
  int q;
  int n;
  int sq;
  int p;
  std::vector<std::vector<int>> counts;
  std::vector<std::vector<int>> spikes;
  double as;
  double bs;
  double atheta;
  double btheta;
  Eigen::Matrix<double,-1,-1> batch_design_data__;
  Eigen::Matrix<double,-1,1> aphi_data__;
  Eigen::Matrix<double,-1,1> mu_mu_data__;
  double smu;
  double astwo;
  double bstwo;
  int l;
  Eigen::Matrix<double,-1,1> mbeta_data__;
  Eigen::Matrix<double,-1,-1> vbeta_data__;
  double rbf_variance;
  Eigen::Matrix<double,-1,1> ml_data__;
  double eta;
  Eigen::Matrix<double,-1,1> spike_levels_data__;
  Eigen::Map<Eigen::Matrix<double,-1,-1>> batch_design{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> aphi{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> mu_mu{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> mbeta{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> vbeta{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> ml{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> spike_levels{nullptr, 0};
public:
  ~model_basics_regression() {}
  model_basics_regression(stan::io::var_context& context__, unsigned int
                          random_seed__ = 0, std::ostream*
                          pstream__ = nullptr) : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_basics_regression_namespace::model_basics_regression";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 28;
      context__.validate_dims("data initialization", "q", "int",
        std::vector<size_t>{});
      q = std::numeric_limits<int>::min();
      current_statement__ = 28;
      q = context__.vals_i("q")[(1 - 1)];
      current_statement__ = 29;
      context__.validate_dims("data initialization", "n", "int",
        std::vector<size_t>{});
      n = std::numeric_limits<int>::min();
      current_statement__ = 29;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 30;
      context__.validate_dims("data initialization", "sq", "int",
        std::vector<size_t>{});
      sq = std::numeric_limits<int>::min();
      current_statement__ = 30;
      sq = context__.vals_i("sq")[(1 - 1)];
      current_statement__ = 31;
      context__.validate_dims("data initialization", "p", "int",
        std::vector<size_t>{});
      p = std::numeric_limits<int>::min();
      current_statement__ = 31;
      p = context__.vals_i("p")[(1 - 1)];
      current_statement__ = 32;
      stan::math::validate_non_negative_index("counts", "q", q);
      current_statement__ = 33;
      stan::math::validate_non_negative_index("counts", "n", n);
      current_statement__ = 34;
      context__.validate_dims("data initialization", "counts", "int",
        std::vector<size_t>{static_cast<size_t>(q), static_cast<size_t>(n)});
      counts = std::vector<std::vector<int>>(q,
                 std::vector<int>(n, std::numeric_limits<int>::min()));
      {
        std::vector<int> counts_flat__;
        current_statement__ = 34;
        counts_flat__ = context__.vals_i("counts");
        current_statement__ = 34;
        pos__ = 1;
        current_statement__ = 34;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 34;
          for (int sym2__ = 1; sym2__ <= q; ++sym2__) {
            current_statement__ = 34;
            stan::model::assign(counts, counts_flat__[(pos__ - 1)],
              "assigning variable counts", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 34;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 34;
      stan::math::check_greater_or_equal(function__, "counts", counts, 0);
      current_statement__ = 35;
      stan::math::validate_non_negative_index("spikes", "sq", sq);
      current_statement__ = 36;
      stan::math::validate_non_negative_index("spikes", "n", n);
      current_statement__ = 37;
      context__.validate_dims("data initialization", "spikes", "int",
        std::vector<size_t>{static_cast<size_t>(sq), static_cast<size_t>(n)});
      spikes = std::vector<std::vector<int>>(sq,
                 std::vector<int>(n, std::numeric_limits<int>::min()));
      {
        std::vector<int> spikes_flat__;
        current_statement__ = 37;
        spikes_flat__ = context__.vals_i("spikes");
        current_statement__ = 37;
        pos__ = 1;
        current_statement__ = 37;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 37;
          for (int sym2__ = 1; sym2__ <= sq; ++sym2__) {
            current_statement__ = 37;
            stan::model::assign(spikes, spikes_flat__[(pos__ - 1)],
              "assigning variable spikes", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 37;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 37;
      stan::math::check_greater_or_equal(function__, "spikes", spikes, 0);
      current_statement__ = 38;
      context__.validate_dims("data initialization", "as", "double",
        std::vector<size_t>{});
      as = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 38;
      as = context__.vals_r("as")[(1 - 1)];
      current_statement__ = 39;
      context__.validate_dims("data initialization", "bs", "double",
        std::vector<size_t>{});
      bs = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 39;
      bs = context__.vals_r("bs")[(1 - 1)];
      current_statement__ = 40;
      context__.validate_dims("data initialization", "atheta", "double",
        std::vector<size_t>{});
      atheta = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 40;
      atheta = context__.vals_r("atheta")[(1 - 1)];
      current_statement__ = 41;
      context__.validate_dims("data initialization", "btheta", "double",
        std::vector<size_t>{});
      btheta = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 41;
      btheta = context__.vals_r("btheta")[(1 - 1)];
      current_statement__ = 42;
      stan::math::validate_non_negative_index("batch_design", "n", n);
      current_statement__ = 43;
      stan::math::validate_non_negative_index("batch_design", "p", p);
      current_statement__ = 44;
      context__.validate_dims("data initialization", "batch_design",
        "double",
        std::vector<size_t>{static_cast<size_t>(n), static_cast<size_t>(p)});
      batch_design_data__ = Eigen::Matrix<double,-1,-1>::Constant(n, p,
                              std::numeric_limits<double>::quiet_NaN());
      new (&batch_design)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(batch_design_data__.data(),
        n, p);
      {
        std::vector<local_scalar_t__> batch_design_flat__;
        current_statement__ = 44;
        batch_design_flat__ = context__.vals_r("batch_design");
        current_statement__ = 44;
        pos__ = 1;
        current_statement__ = 44;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 44;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 44;
            stan::model::assign(batch_design, batch_design_flat__[(pos__ -
              1)], "assigning variable batch_design",
              stan::model::index_uni(sym2__), stan::model::index_uni(sym1__));
            current_statement__ = 44;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 45;
      stan::math::validate_non_negative_index("aphi", "n", n);
      current_statement__ = 46;
      context__.validate_dims("data initialization", "aphi", "double",
        std::vector<size_t>{static_cast<size_t>(n)});
      aphi_data__ = Eigen::Matrix<double,-1,1>::Constant(n,
                      std::numeric_limits<double>::quiet_NaN());
      new (&aphi) Eigen::Map<Eigen::Matrix<double,-1,1>>(aphi_data__.data(),
        n);
      {
        std::vector<local_scalar_t__> aphi_flat__;
        current_statement__ = 46;
        aphi_flat__ = context__.vals_r("aphi");
        current_statement__ = 46;
        pos__ = 1;
        current_statement__ = 46;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 46;
          stan::model::assign(aphi, aphi_flat__[(pos__ - 1)],
            "assigning variable aphi", stan::model::index_uni(sym1__));
          current_statement__ = 46;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 47;
      stan::math::validate_non_negative_index("mu_mu", "q", q);
      current_statement__ = 48;
      context__.validate_dims("data initialization", "mu_mu", "double",
        std::vector<size_t>{static_cast<size_t>(q)});
      mu_mu_data__ = Eigen::Matrix<double,-1,1>::Constant(q,
                       std::numeric_limits<double>::quiet_NaN());
      new (&mu_mu)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(mu_mu_data__.data(), q);
      {
        std::vector<local_scalar_t__> mu_mu_flat__;
        current_statement__ = 48;
        mu_mu_flat__ = context__.vals_r("mu_mu");
        current_statement__ = 48;
        pos__ = 1;
        current_statement__ = 48;
        for (int sym1__ = 1; sym1__ <= q; ++sym1__) {
          current_statement__ = 48;
          stan::model::assign(mu_mu, mu_mu_flat__[(pos__ - 1)],
            "assigning variable mu_mu", stan::model::index_uni(sym1__));
          current_statement__ = 48;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 49;
      context__.validate_dims("data initialization", "smu", "double",
        std::vector<size_t>{});
      smu = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 49;
      smu = context__.vals_r("smu")[(1 - 1)];
      current_statement__ = 50;
      context__.validate_dims("data initialization", "astwo", "double",
        std::vector<size_t>{});
      astwo = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 50;
      astwo = context__.vals_r("astwo")[(1 - 1)];
      current_statement__ = 51;
      context__.validate_dims("data initialization", "bstwo", "double",
        std::vector<size_t>{});
      bstwo = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 51;
      bstwo = context__.vals_r("bstwo")[(1 - 1)];
      current_statement__ = 52;
      context__.validate_dims("data initialization", "l", "int",
        std::vector<size_t>{});
      l = std::numeric_limits<int>::min();
      current_statement__ = 52;
      l = context__.vals_i("l")[(1 - 1)];
      current_statement__ = 53;
      stan::math::validate_non_negative_index("mbeta", "l", l);
      current_statement__ = 54;
      context__.validate_dims("data initialization", "mbeta", "double",
        std::vector<size_t>{static_cast<size_t>(l)});
      mbeta_data__ = Eigen::Matrix<double,-1,1>::Constant(l,
                       std::numeric_limits<double>::quiet_NaN());
      new (&mbeta)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(mbeta_data__.data(), l);
      {
        std::vector<local_scalar_t__> mbeta_flat__;
        current_statement__ = 54;
        mbeta_flat__ = context__.vals_r("mbeta");
        current_statement__ = 54;
        pos__ = 1;
        current_statement__ = 54;
        for (int sym1__ = 1; sym1__ <= l; ++sym1__) {
          current_statement__ = 54;
          stan::model::assign(mbeta, mbeta_flat__[(pos__ - 1)],
            "assigning variable mbeta", stan::model::index_uni(sym1__));
          current_statement__ = 54;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 55;
      stan::math::validate_non_negative_index("vbeta", "l", l);
      current_statement__ = 56;
      stan::math::validate_non_negative_index("vbeta", "l", l);
      current_statement__ = 57;
      context__.validate_dims("data initialization", "vbeta", "double",
        std::vector<size_t>{static_cast<size_t>(l), static_cast<size_t>(l)});
      vbeta_data__ = Eigen::Matrix<double,-1,-1>::Constant(l, l,
                       std::numeric_limits<double>::quiet_NaN());
      new (&vbeta)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(vbeta_data__.data(), l, l);
      {
        std::vector<local_scalar_t__> vbeta_flat__;
        current_statement__ = 57;
        vbeta_flat__ = context__.vals_r("vbeta");
        current_statement__ = 57;
        pos__ = 1;
        current_statement__ = 57;
        for (int sym1__ = 1; sym1__ <= l; ++sym1__) {
          current_statement__ = 57;
          for (int sym2__ = 1; sym2__ <= l; ++sym2__) {
            current_statement__ = 57;
            stan::model::assign(vbeta, vbeta_flat__[(pos__ - 1)],
              "assigning variable vbeta", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 57;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 58;
      context__.validate_dims("data initialization", "rbf_variance",
        "double", std::vector<size_t>{});
      rbf_variance = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 58;
      rbf_variance = context__.vals_r("rbf_variance")[(1 - 1)];
      current_statement__ = 59;
      stan::math::validate_non_negative_index("ml", "l - 2", (l - 2));
      current_statement__ = 60;
      context__.validate_dims("data initialization", "ml", "double",
        std::vector<size_t>{static_cast<size_t>((l - 2))});
      ml_data__ = Eigen::Matrix<double,-1,1>::Constant((l - 2),
                    std::numeric_limits<double>::quiet_NaN());
      new (&ml) Eigen::Map<Eigen::Matrix<double,-1,1>>(ml_data__.data(), (l -
        2));
      {
        std::vector<local_scalar_t__> ml_flat__;
        current_statement__ = 60;
        ml_flat__ = context__.vals_r("ml");
        current_statement__ = 60;
        pos__ = 1;
        current_statement__ = 60;
        for (int sym1__ = 1; sym1__ <= (l - 2); ++sym1__) {
          current_statement__ = 60;
          stan::model::assign(ml, ml_flat__[(pos__ - 1)],
            "assigning variable ml", stan::model::index_uni(sym1__));
          current_statement__ = 60;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 61;
      context__.validate_dims("data initialization", "eta", "double",
        std::vector<size_t>{});
      eta = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 61;
      eta = context__.vals_r("eta")[(1 - 1)];
      current_statement__ = 62;
      stan::math::validate_non_negative_index("spike_levels", "sq", sq);
      current_statement__ = 63;
      context__.validate_dims("data initialization", "spike_levels",
        "double", std::vector<size_t>{static_cast<size_t>(sq)});
      spike_levels_data__ = Eigen::Matrix<double,-1,1>::Constant(sq,
                              std::numeric_limits<double>::quiet_NaN());
      new (&spike_levels)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(spike_levels_data__.data(),
        sq);
      {
        std::vector<local_scalar_t__> spike_levels_flat__;
        current_statement__ = 63;
        spike_levels_flat__ = context__.vals_r("spike_levels");
        current_statement__ = 63;
        pos__ = 1;
        current_statement__ = 63;
        for (int sym1__ = 1; sym1__ <= sq; ++sym1__) {
          current_statement__ = 63;
          stan::model::assign(spike_levels, spike_levels_flat__[(pos__ - 1)],
            "assigning variable spike_levels", stan::model::index_uni(sym1__));
          current_statement__ = 63;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 64;
      stan::math::validate_non_negative_index("log_mu", "q", q);
      current_statement__ = 65;
      stan::math::validate_non_negative_index("delta", "q", q);
      current_statement__ = 66;
      stan::math::validate_positive_index("tphi", "n", n);
      current_statement__ = 67;
      stan::math::validate_non_negative_index("nu", "n", n);
      current_statement__ = 68;
      stan::math::validate_non_negative_index("s", "n", n);
      current_statement__ = 69;
      stan::math::validate_non_negative_index("theta", "p", p);
      current_statement__ = 70;
      stan::math::validate_non_negative_index("beta", "l", l);
      current_statement__ = 71;
      stan::math::validate_non_negative_index("lambda", "q", q);
      current_statement__ = 72;
      stan::math::validate_non_negative_index("theta_vector", "n", n);
      current_statement__ = 73;
      stan::math::validate_non_negative_index("phi", "n", n);
      current_statement__ = 74;
      stan::math::validate_non_negative_index("mu", "q", q);
      current_statement__ = 75;
      stan::math::validate_non_negative_index("fu", "q", q);
      current_statement__ = 76;
      stan::math::validate_non_negative_index("epsilon", "q", q);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = q + q + (n - 1) + n + n + p + l + 1 + q;
  }
  inline std::string model_name() const final {
    return "model_basics_regression";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_basics_regression_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,1> log_mu =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(q, DUMMY_VAR__);
      current_statement__ = 1;
      log_mu = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(q);
      Eigen::Matrix<local_scalar_t__,-1,1> delta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(q, DUMMY_VAR__);
      current_statement__ = 2;
      delta = in__.template read_constrain_lb<
                Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0, lp__, q);
      Eigen::Matrix<local_scalar_t__,-1,1> tphi =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
      current_statement__ = 3;
      tphi = in__.template read_constrain_simplex<
               Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(lp__, n);
      std::vector<local_scalar_t__> nu =
        std::vector<local_scalar_t__>(n, DUMMY_VAR__);
      current_statement__ = 4;
      nu = in__.template read_constrain_lb<std::vector<local_scalar_t__>,
             jacobian__>(0, lp__, n);
      Eigen::Matrix<local_scalar_t__,-1,1> s =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
      current_statement__ = 5;
      s = in__.template read_constrain_lb<
            Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0, lp__, n);
      Eigen::Matrix<local_scalar_t__,-1,1> theta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      current_statement__ = 6;
      theta = in__.template read_constrain_lb<
                Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0, lp__, p);
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(l, DUMMY_VAR__);
      current_statement__ = 7;
      beta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(l);
      local_scalar_t__ stwo = DUMMY_VAR__;
      current_statement__ = 8;
      stwo = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
               lp__);
      Eigen::Matrix<local_scalar_t__,-1,1> lambda =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(q, DUMMY_VAR__);
      current_statement__ = 9;
      lambda = in__.template read_constrain_lb<
                 Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0, lp__,
                 q);
      Eigen::Matrix<local_scalar_t__,-1,1> theta_vector =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
      current_statement__ = 10;
      stan::model::assign(theta_vector,
        stan::math::multiply(batch_design, theta),
        "assigning variable theta_vector");
      Eigen::Matrix<local_scalar_t__,-1,1> phi =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
      current_statement__ = 11;
      stan::model::assign(phi, stan::math::multiply(tphi, n),
        "assigning variable phi");
      Eigen::Matrix<local_scalar_t__,-1,1> mu =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(q, DUMMY_VAR__);
      current_statement__ = 12;
      stan::model::assign(mu, stan::math::exp(log_mu),
        "assigning variable mu");
      Eigen::Matrix<local_scalar_t__,-1,1> fu =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(q, DUMMY_VAR__);
      current_statement__ = 13;
      stan::model::assign(fu,
        stan::math::multiply(
          designMatrix(l, log_mu, rbf_variance, ml, q, pstream__), beta),
        "assigning variable fu");
      Eigen::Matrix<local_scalar_t__,-1,1> epsilon =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(q, DUMMY_VAR__);
      current_statement__ = 14;
      stan::model::assign(epsilon,
        stan::math::subtract(stan::math::log(delta), fu),
        "assigning variable epsilon");
      current_statement__ = 10;
      stan::math::check_greater_or_equal(function__, "theta_vector",
        theta_vector, 0);
      current_statement__ = 11;
      stan::math::check_greater_or_equal(function__, "phi", phi, 0);
      current_statement__ = 12;
      stan::math::check_greater_or_equal(function__, "mu", mu, 0);
      {
        current_statement__ = 15;
        lp_accum__.add(stan::math::gamma_lpdf<propto__>(theta, atheta, btheta));
        current_statement__ = 16;
        lp_accum__.add(stan::math::dirichlet_lpdf<propto__>(tphi, aphi));
        current_statement__ = 17;
        lp_accum__.add(stan::math::inv_gamma_lpdf<propto__>(stwo, astwo,
                         bstwo));
        current_statement__ = 18;
        lp_accum__.add(stan::math::multi_normal_lpdf<propto__>(beta, mbeta,
                         stan::math::multiply(stwo, vbeta)));
        current_statement__ = 19;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(log_mu, mu_mu, smu));
        current_statement__ = 20;
        lp_accum__.add(stan::math::gamma_lpdf<propto__>(lambda, (eta / 2),
                         (eta / 2)));
        current_statement__ = 21;
        lp_accum__.add(stan::math::lognormal_lpdf<propto__>(delta, fu,
                         stan::math::elt_divide(stwo,
                           stan::math::sqrt(lambda))));
        current_statement__ = 22;
        lp_accum__.add(stan::math::gamma_lpdf<propto__>(s, as, bs));
        current_statement__ = 23;
        lp_accum__.add(stan::math::gamma_lpdf<propto__>(nu,
                         stan::math::elt_divide(1, theta_vector),
                         stan::math::elt_divide(1,
                           stan::math::elt_multiply(s, theta_vector))));
        current_statement__ = 27;
        for (int j = 1; j <= n; ++j) {
          current_statement__ = 24;
          lp_accum__.add(stan::math::neg_binomial_2_log_lpmf<propto__>(
                           stan::model::rvalue(counts, "counts",
                             stan::model::index_omni(),
                             stan::model::index_uni(j)),
                           stan::math::add(
                             (stan::math::log(
                                stan::model::rvalue(phi, "phi",
                                  stan::model::index_uni(j))) +
                             stan::math::log(
                               stan::model::rvalue(nu, "nu",
                                 stan::model::index_uni(j)))), log_mu),
                           stan::math::elt_divide(1, delta)));
          current_statement__ = 25;
          lp_accum__.add(stan::math::poisson_lpmf<propto__>(
                           stan::model::rvalue(spikes, "spikes",
                             stan::model::index_omni(),
                             stan::model::index_uni(j)),
                           stan::math::multiply(
                             stan::model::rvalue(nu, "nu",
                               stan::model::index_uni(j)), spike_levels)));
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_basics_regression_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,1> log_mu =
        Eigen::Matrix<double,-1,1>::Constant(q,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      log_mu = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(q);
      Eigen::Matrix<double,-1,1> delta =
        Eigen::Matrix<double,-1,1>::Constant(q,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 2;
      delta = in__.template read_constrain_lb<
                Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0, lp__, q);
      Eigen::Matrix<double,-1,1> tphi =
        Eigen::Matrix<double,-1,1>::Constant(n,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 3;
      tphi = in__.template read_constrain_simplex<
               Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(lp__, n);
      std::vector<double> nu =
        std::vector<double>(n, std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 4;
      nu = in__.template read_constrain_lb<std::vector<local_scalar_t__>,
             jacobian__>(0, lp__, n);
      Eigen::Matrix<double,-1,1> s =
        Eigen::Matrix<double,-1,1>::Constant(n,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 5;
      s = in__.template read_constrain_lb<
            Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0, lp__, n);
      Eigen::Matrix<double,-1,1> theta =
        Eigen::Matrix<double,-1,1>::Constant(p,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 6;
      theta = in__.template read_constrain_lb<
                Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0, lp__, p);
      Eigen::Matrix<double,-1,1> beta =
        Eigen::Matrix<double,-1,1>::Constant(l,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 7;
      beta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(l);
      double stwo = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 8;
      stwo = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
               lp__);
      Eigen::Matrix<double,-1,1> lambda =
        Eigen::Matrix<double,-1,1>::Constant(q,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 9;
      lambda = in__.template read_constrain_lb<
                 Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0, lp__,
                 q);
      Eigen::Matrix<double,-1,1> theta_vector =
        Eigen::Matrix<double,-1,1>::Constant(n,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> phi =
        Eigen::Matrix<double,-1,1>::Constant(n,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> mu =
        Eigen::Matrix<double,-1,1>::Constant(q,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> fu =
        Eigen::Matrix<double,-1,1>::Constant(q,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> epsilon =
        Eigen::Matrix<double,-1,1>::Constant(q,
          std::numeric_limits<double>::quiet_NaN());
      out__.write(log_mu);
      out__.write(delta);
      out__.write(tphi);
      out__.write(nu);
      out__.write(s);
      out__.write(theta);
      out__.write(beta);
      out__.write(stwo);
      out__.write(lambda);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 10;
      stan::model::assign(theta_vector,
        stan::math::multiply(batch_design, theta),
        "assigning variable theta_vector");
      current_statement__ = 11;
      stan::model::assign(phi, stan::math::multiply(tphi, n),
        "assigning variable phi");
      current_statement__ = 12;
      stan::model::assign(mu, stan::math::exp(log_mu),
        "assigning variable mu");
      current_statement__ = 13;
      stan::model::assign(fu,
        stan::math::multiply(
          designMatrix(l, log_mu, rbf_variance, ml, q, pstream__), beta),
        "assigning variable fu");
      current_statement__ = 14;
      stan::model::assign(epsilon,
        stan::math::subtract(stan::math::log(delta), fu),
        "assigning variable epsilon");
      current_statement__ = 10;
      stan::math::check_greater_or_equal(function__, "theta_vector",
        theta_vector, 0);
      current_statement__ = 11;
      stan::math::check_greater_or_equal(function__, "phi", phi, 0);
      current_statement__ = 12;
      stan::math::check_greater_or_equal(function__, "mu", mu, 0);
      if (emit_transformed_parameters__) {
        out__.write(theta_vector);
        out__.write(phi);
        out__.write(mu);
        out__.write(fu);
        out__.write(epsilon);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> log_mu =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(q, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(log_mu,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(q),
        "assigning variable log_mu");
      out__.write(log_mu);
      Eigen::Matrix<local_scalar_t__,-1,1> delta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(q, DUMMY_VAR__);
      current_statement__ = 2;
      stan::model::assign(delta,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(q),
        "assigning variable delta");
      out__.write_free_lb(0, delta);
      Eigen::Matrix<local_scalar_t__,-1,1> tphi =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
      current_statement__ = 3;
      stan::model::assign(tphi,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(n),
        "assigning variable tphi");
      out__.write_free_simplex(tphi);
      std::vector<local_scalar_t__> nu =
        std::vector<local_scalar_t__>(n, DUMMY_VAR__);
      current_statement__ = 4;
      stan::model::assign(nu, in__.read<std::vector<local_scalar_t__>>(n),
        "assigning variable nu");
      out__.write_free_lb(0, nu);
      Eigen::Matrix<local_scalar_t__,-1,1> s =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
      current_statement__ = 5;
      stan::model::assign(s,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(n),
        "assigning variable s");
      out__.write_free_lb(0, s);
      Eigen::Matrix<local_scalar_t__,-1,1> theta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      current_statement__ = 6;
      stan::model::assign(theta,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(p),
        "assigning variable theta");
      out__.write_free_lb(0, theta);
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(l, DUMMY_VAR__);
      current_statement__ = 7;
      stan::model::assign(beta,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(l),
        "assigning variable beta");
      out__.write(beta);
      local_scalar_t__ stwo = DUMMY_VAR__;
      current_statement__ = 8;
      stwo = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, stwo);
      Eigen::Matrix<local_scalar_t__,-1,1> lambda =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(q, DUMMY_VAR__);
      current_statement__ = 9;
      stan::model::assign(lambda,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(q),
        "assigning variable lambda");
      out__.write_free_lb(0, lambda);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "log_mu", "double",
        std::vector<size_t>{static_cast<size_t>(q)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "delta", "double",
        std::vector<size_t>{static_cast<size_t>(q)});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "tphi", "double",
        std::vector<size_t>{static_cast<size_t>(n)});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "nu", "double",
        std::vector<size_t>{static_cast<size_t>(n)});
      current_statement__ = 5;
      context__.validate_dims("parameter initialization", "s", "double",
        std::vector<size_t>{static_cast<size_t>(n)});
      current_statement__ = 6;
      context__.validate_dims("parameter initialization", "theta", "double",
        std::vector<size_t>{static_cast<size_t>(p)});
      current_statement__ = 7;
      context__.validate_dims("parameter initialization", "beta", "double",
        std::vector<size_t>{static_cast<size_t>(l)});
      current_statement__ = 8;
      context__.validate_dims("parameter initialization", "stwo", "double",
        std::vector<size_t>{});
      current_statement__ = 9;
      context__.validate_dims("parameter initialization", "lambda", "double",
        std::vector<size_t>{static_cast<size_t>(q)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> log_mu =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(q, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> log_mu_flat__;
        current_statement__ = 1;
        log_mu_flat__ = context__.vals_r("log_mu");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= q; ++sym1__) {
          current_statement__ = 1;
          stan::model::assign(log_mu, log_mu_flat__[(pos__ - 1)],
            "assigning variable log_mu", stan::model::index_uni(sym1__));
          current_statement__ = 1;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(log_mu);
      Eigen::Matrix<local_scalar_t__,-1,1> delta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(q, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> delta_flat__;
        current_statement__ = 2;
        delta_flat__ = context__.vals_r("delta");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= q; ++sym1__) {
          current_statement__ = 2;
          stan::model::assign(delta, delta_flat__[(pos__ - 1)],
            "assigning variable delta", stan::model::index_uni(sym1__));
          current_statement__ = 2;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_lb(0, delta);
      Eigen::Matrix<local_scalar_t__,-1,1> tphi =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> tphi_flat__;
        current_statement__ = 3;
        tphi_flat__ = context__.vals_r("tphi");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 3;
          stan::model::assign(tphi, tphi_flat__[(pos__ - 1)],
            "assigning variable tphi", stan::model::index_uni(sym1__));
          current_statement__ = 3;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_simplex(tphi);
      std::vector<local_scalar_t__> nu =
        std::vector<local_scalar_t__>(n, DUMMY_VAR__);
      current_statement__ = 4;
      nu = context__.vals_r("nu");
      out__.write_free_lb(0, nu);
      Eigen::Matrix<local_scalar_t__,-1,1> s =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> s_flat__;
        current_statement__ = 5;
        s_flat__ = context__.vals_r("s");
        current_statement__ = 5;
        pos__ = 1;
        current_statement__ = 5;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 5;
          stan::model::assign(s, s_flat__[(pos__ - 1)],
            "assigning variable s", stan::model::index_uni(sym1__));
          current_statement__ = 5;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_lb(0, s);
      Eigen::Matrix<local_scalar_t__,-1,1> theta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> theta_flat__;
        current_statement__ = 6;
        theta_flat__ = context__.vals_r("theta");
        current_statement__ = 6;
        pos__ = 1;
        current_statement__ = 6;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 6;
          stan::model::assign(theta, theta_flat__[(pos__ - 1)],
            "assigning variable theta", stan::model::index_uni(sym1__));
          current_statement__ = 6;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_lb(0, theta);
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(l, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 7;
        beta_flat__ = context__.vals_r("beta");
        current_statement__ = 7;
        pos__ = 1;
        current_statement__ = 7;
        for (int sym1__ = 1; sym1__ <= l; ++sym1__) {
          current_statement__ = 7;
          stan::model::assign(beta, beta_flat__[(pos__ - 1)],
            "assigning variable beta", stan::model::index_uni(sym1__));
          current_statement__ = 7;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(beta);
      local_scalar_t__ stwo = DUMMY_VAR__;
      current_statement__ = 8;
      stwo = context__.vals_r("stwo")[(1 - 1)];
      out__.write_free_lb(0, stwo);
      Eigen::Matrix<local_scalar_t__,-1,1> lambda =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(q, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> lambda_flat__;
        current_statement__ = 9;
        lambda_flat__ = context__.vals_r("lambda");
        current_statement__ = 9;
        pos__ = 1;
        current_statement__ = 9;
        for (int sym1__ = 1; sym1__ <= q; ++sym1__) {
          current_statement__ = 9;
          stan::model::assign(lambda, lambda_flat__[(pos__ - 1)],
            "assigning variable lambda", stan::model::index_uni(sym1__));
          current_statement__ = 9;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_lb(0, lambda);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"log_mu", "delta", "tphi", "nu", "s",
                "theta", "beta", "stwo", "lambda"};
    if (emit_transformed_parameters__) {
      std::vector<std::string>
        temp{"theta_vector", "phi", "mu", "fu", "epsilon"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(q)},
                std::vector<size_t>{static_cast<size_t>(q)},
                std::vector<size_t>{static_cast<size_t>(n)},
                std::vector<size_t>{static_cast<size_t>(n)},
                std::vector<size_t>{static_cast<size_t>(n)},
                std::vector<size_t>{static_cast<size_t>(p)},
                std::vector<size_t>{static_cast<size_t>(l)},
                std::vector<size_t>{},
                std::vector<size_t>{static_cast<size_t>(q)}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(n)},
             std::vector<size_t>{static_cast<size_t>(n)},
             std::vector<size_t>{static_cast<size_t>(q)},
             std::vector<size_t>{static_cast<size_t>(q)},
             std::vector<size_t>{static_cast<size_t>(q)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= q; ++sym1__) {
      param_names__.emplace_back(std::string() + "log_mu" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= q; ++sym1__) {
      param_names__.emplace_back(std::string() + "delta" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
      param_names__.emplace_back(std::string() + "tphi" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
      param_names__.emplace_back(std::string() + "nu" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
      param_names__.emplace_back(std::string() + "s" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
      param_names__.emplace_back(std::string() + "theta" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= l; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "stwo");
    for (int sym1__ = 1; sym1__ <= q; ++sym1__) {
      param_names__.emplace_back(std::string() + "lambda" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        param_names__.emplace_back(std::string() + "theta_vector" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        param_names__.emplace_back(std::string() + "phi" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= q; ++sym1__) {
        param_names__.emplace_back(std::string() + "mu" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= q; ++sym1__) {
        param_names__.emplace_back(std::string() + "fu" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= q; ++sym1__) {
        param_names__.emplace_back(std::string() + "epsilon" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= q; ++sym1__) {
      param_names__.emplace_back(std::string() + "log_mu" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= q; ++sym1__) {
      param_names__.emplace_back(std::string() + "delta" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= (n - 1); ++sym1__) {
      param_names__.emplace_back(std::string() + "tphi" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
      param_names__.emplace_back(std::string() + "nu" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
      param_names__.emplace_back(std::string() + "s" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
      param_names__.emplace_back(std::string() + "theta" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= l; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "stwo");
    for (int sym1__ = 1; sym1__ <= q; ++sym1__) {
      param_names__.emplace_back(std::string() + "lambda" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        param_names__.emplace_back(std::string() + "theta_vector" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        param_names__.emplace_back(std::string() + "phi" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= q; ++sym1__) {
        param_names__.emplace_back(std::string() + "mu" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= q; ++sym1__) {
        param_names__.emplace_back(std::string() + "fu" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= q; ++sym1__) {
        param_names__.emplace_back(std::string() + "epsilon" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {}
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"log_mu\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(q) + "},\"block\":\"parameters\"},{\"name\":\"delta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(q) + "},\"block\":\"parameters\"},{\"name\":\"tphi\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n) + "},\"block\":\"parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(n) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"s\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n) + "},\"block\":\"parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(p) + "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(l) + "},\"block\":\"parameters\"},{\"name\":\"stwo\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"lambda\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(q) + "},\"block\":\"parameters\"},{\"name\":\"theta_vector\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n) + "},\"block\":\"transformed_parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n) + "},\"block\":\"transformed_parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(q) + "},\"block\":\"transformed_parameters\"},{\"name\":\"fu\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(q) + "},\"block\":\"transformed_parameters\"},{\"name\":\"epsilon\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(q) + "},\"block\":\"transformed_parameters\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"log_mu\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(q) + "},\"block\":\"parameters\"},{\"name\":\"delta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(q) + "},\"block\":\"parameters\"},{\"name\":\"tphi\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string((n -1)) + "},\"block\":\"parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(n) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"s\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n) + "},\"block\":\"parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(p) + "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(l) + "},\"block\":\"parameters\"},{\"name\":\"stwo\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"lambda\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(q) + "},\"block\":\"parameters\"},{\"name\":\"theta_vector\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n) + "},\"block\":\"transformed_parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n) + "},\"block\":\"transformed_parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(q) + "},\"block\":\"transformed_parameters\"},{\"name\":\"fu\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(q) + "},\"block\":\"transformed_parameters\"},{\"name\":\"epsilon\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(q) + "},\"block\":\"transformed_parameters\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((((((q + q) + n) + n) + n) + p) + l) + 1)
      + q);
    const size_t num_transformed = emit_transformed_parameters * (((((n + n)
      + q) + q) + q));
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((((((q + q) + n) + n) + n) + p) + l) + 1)
      + q);
    const size_t num_transformed = emit_transformed_parameters * (((((n + n)
      + q) + q) + q));
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_basics_regression_namespace::model_basics_regression;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_basics_regression_namespace::profiles__;
}
#endif
#endif
