% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeExampleBASiCS_Data.R
\name{makeExampleBASiCS_Data}
\alias{makeExampleBASiCS_Data}
\title{Create a synthetic SingleCellExperiment example object with the
format required for BASiCS}
\usage{
makeExampleBASiCS_Data(WithBatch = FALSE, WithSpikes = TRUE)
}
\arguments{
\item{WithBatch}{If \code{TRUE}, 2 batches are generated (each of them
containing 15 cells). Default: \code{WithBatch = FALSE}.}

\item{WithSpikes}{If \code{TRUE}, the simulated dataset contains 20 spike-in
genes. If \code{WithSpikes = FALSE}, \code{WithBatch} is automatically set
to \code{TRUE}. Default: \code{WithSpikes = TRUE}}
}
\value{
An object of class \code{\link[SingleCellExperiment]{SingleCellExperiment-class}}, with
synthetic data simulated from the model implemented in BASiCS.
If \code{WithSpikes = TRUE}, it contains 70 genes (50 biological and
20 spike-in) and 30 cells. Alternatively, it contains 50 biological
genes and 30 cells.
}
\description{
A synthetic \code{\link[SingleCellExperiment]{SingleCellExperiment-class}} object is
generated by simulating a dataset from the model underlying BASiCS. This is
used to illustrate BASiCS in some of the package and vignette examples.
}
\details{
Note: In BASiCS versions < 1.5.22, \code{makeExampleBASiCS_Data} 
used a fixed seed within the function. This has been removed to comply with 
Bioconductor policies. If a reproducible example is required, please use 
\code{set.seed} prior to calling \code{makeExampleBASiCS_Data} .
}
\examples{
Data <- makeExampleBASiCS_Data()
is(Data, 'SingleCellExperiment')

}
\author{
Catalina A. Vallejos \email{cnvallej@uc.cl}

Nils Eling \email{eling@ebi.ac.uk}
}
