% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BASiCS_PlotVarianceDecomp.R
\name{BASiCS_PlotVarianceDecomp}
\alias{BASiCS_PlotVarianceDecomp}
\title{Plot variance decomposition results.}
\usage{
BASiCS_PlotVarianceDecomp(
  Decomp,
  beside = FALSE,
  nBatch = ((ncol(Decomp) - 2)/3) - 1,
  main = "Overall variance decomposition",
  xlabs = if (nBatch == 1) "Overall" else c("Overall", paste("Batch", seq_len(nBatch))),
  ylab = "\% of variance"
)
}
\arguments{
\item{Decomp}{The output of \code{\link{BASiCS_VarianceDecomp}}.}

\item{beside}{If \code{TRUE}, bars are placed beside each other.
If \code{FALSE}, bars are stacked.}

\item{nBatch}{Number of batches.}

\item{main}{Plot title.}

\item{xlabs}{x-axis labels. Defaults to "Batch 1", "Batch 2", etc.}

\item{ylab}{y axis label.}
}
\value{
A ggplot object.
}
\description{
Plot variance decomposition results.
}
