% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BASiCS_CorrectOffset.R
\name{BASiCS_CorrectOffset}
\alias{BASiCS_CorrectOffset}
\title{Remove global mean expression offset}
\usage{
BASiCS_CorrectOffset(Chain, ChainRef, min.mean = 1)
}
\arguments{
\item{Chain}{a `BASiCS_MCMC` object to which the offset correction should 
be applied (with respect to `ChainRef`).}

\item{ChainRef}{a `BASiCS_MCMC` object to be used as the reference in the
offset correction procedure.}

\item{min.mean}{Minimum mean expression threshold required for inclusion in
offset calculation. Similar to `min.mean` in `scran::computeSumFactors`.}
}
\value{
A list whose first element is an offset corrected version of `Chain` 
(using `ChainRef` as a reference), whose second element is the point estimate
for the offset and whose third element contains iteration-specific offsets.
}
\description{
Remove global offset in mean expression between two 
\code{BASiCS_Chain} objects.
}
\examples{

# Loading two 'BASiCS_Chain' objects (obtained using 'BASiCS_MCMC')
data(ChainSC)
data(ChainRNA)

A <- BASiCS_CorrectOffset(ChainSC, ChainRNA)

# Offset corrected versions for ChainSC (with respect to ChainRNA). 
A$Chain
A$Offset

}
\author{
Catalina A. Vallejos \email{cnvallej@uc.cl}

Nils Eling \email{eling@ebi.ac.uk}

Alan O'Callaghan
}
