% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspace_env.R
\name{workspace-env}
\alias{workspace-env}
\alias{workspace_id}
\alias{workspace_storage_container_id}
\alias{workspace_storage_container_url}
\alias{workspace_data_service_url}
\alias{workspace_storage_cont_id}
\alias{workspace_storage_cont_url}
\alias{wds_api_version}
\alias{cbas_url}
\title{Access Terra on Azure workspace session variables}
\usage{
workspace_id()

workspace_storage_cont_id()

workspace_storage_cont_url()

wds_api_version()

workspace_data_service_url()

cbas_url()
}
\value{
\itemize{
\item \code{workspace_id} - A UUID string referring to "workspaceId" or "workspaceid"
in API calls
\item \code{workspace_storage_cont_id} - A UUID string identifiying the resource
storage container owned by the user account, a.k.a. "resourceId"
\item \code{workspace_storage_cont_url} - The base URI string used to move data
to and from the Azure Storage Container
\item \code{wds_api_version} - The version of the Workspace Data Service API, defaults
to "v0.2"
\item \code{workspace_data_service_url} - The base URI string used to move data to
to and from the workspace "DATA" tab
\item \code{cbas_url} - The base URI string used to query the workflow submission
history
}
}
\description{
A group of functions that return environment variables in the
Terra Azure workspace. The Workspace Data Service URL sends out an API
\code{GET} request to obtain the data services URL for uploading data to the
workspace "DATA" tab.
}
\examples{
workspace_id()
workspace_storage_cont_id()
workspace_storage_cont_url()
if (interactive()) {
  workspace_data_service_url()
  cbas_url()
}
}
