% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D-matrices.R
\name{dMatrix}
\alias{dMatrix}
\title{Constructing D-Matrices}
\usage{
dMatrix(nodelist, cytosine, posteriorMaxFilter)
}
\arguments{
\item{nodelist}{list of samples, you can find sample file in
"extdata" called "nodelist.fn"}

\item{cytosine}{Type of cytosine (CHH/CHG/CG)}

\item{posteriorMaxFilter}{Filter value, based on posteriorMax
ex: >= 0.95 or 0.99}
}
\value{
generating divergence matrices file.
}
\description{
Estimating epimutation rates from high-throughput DNA methylation data
}
\examples{
# Get some toy data
file <- system.file("extdata/dm/","nodelist.fn", package="AlphaBeta")
df<-read.csv(file)
df$filename<-sub("^",paste0(dirname(file),"/"),df$filename )
write.csv(df, file = paste0(dirname(file),"tmp_nodelist.fn"),row.names=FALSE,quote=FALSE)
file <- system.file("extdata/dm/","tmp_nodelist.fn", package="AlphaBeta")
dMatrix(file, "CG", 0.99)
}
