% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapbias-methods.R
\docType{methods}
\name{refAllele}
\alias{refAllele}
\alias{refAllele,ASEset-method}
\title{Reference allele}
\usage{
refAllele(x, fasta)
}
\arguments{
\item{x}{\code{ASEset} object}

\item{fasta}{path to fasta file, index should be located in the same folder}
}
\description{
Extract the allele based on SNP location from the reference fasta file
}
\details{
The alleles will be placed in the rowRanges() meta column 'ref'
}
\examples{

#load example data
data(ASEset.sim)

fasta <- system.file('extdata/hg19.chr17.subset.fa', package='AllelicImbalance')
a <- refAllele(ASEset.sim,fasta=fasta) 

}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{mapbias}
\keyword{reference}
