% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxillary-methods.R
\docType{methods}
\name{ASEsetFromBam}
\alias{ASEsetFromBam}
\alias{ASEsetFromBam,GRanges-method}
\title{ASEset from bam file}
\usage{
ASEsetFromBam(gr, ...)

\S4method{ASEsetFromBam}{GRanges}(
  gr,
  pathToDir,
  PE = TRUE,
  flagsMinusStrand = c(83, 163),
  flagsPlusStrand = c(99, 147),
  strandUnknown = FALSE,
  ...
)
}
\arguments{
\item{gr}{GenomicRanges of SNPs to create ASEset for}

\item{...}{passed on to ASEsetFromBam function}

\item{pathToDir}{Directory of bam files with index in same directory}

\item{PE}{if paired end or not (default: TRUE)}

\item{flagsMinusStrand}{flags that mark reads coming from minus strand}

\item{flagsPlusStrand}{flags that mark reads coming from plus strand}

\item{strandUnknown}{default: FALSE}
}
\description{
count alleles and create an ASEset direct from bam file instead of reading into R first.
}
\details{
counts the alleles in a bam file based on GRanges positions.
}
\examples{

data(GRvariants)
gr <- GRvariants

##no execution at the moment
#pathToDir <- system.file('inst/extdata/ERP000101_subset', package='AllelicImbalance')
#a <- ASEsetFromBam(gr, pathToDir)

}
\author{
Jesper R. Gadin
}
\keyword{ASEset}
