% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotScanFrequency.R
\name{getRetentionTimeAndPrecursorInfo}
\alias{getRetentionTimeAndPrecursorInfo}
\title{get retention time and precursor mass from scans list of ft file}
\usage{
getRetentionTimeAndPrecursorInfo(ft)
}
\arguments{
\item{ft}{Scans list of ft file}
}
\value{
A data.frame of retention time and precursor mass
}
\description{
get retention time and precursor mass from scans list of ft file
}
\examples{
demo_file <- system.file("extdata", "demo.FT2", package = "Aerith")
a <- readAllScanMS2(demo_file)
b <- getRetentionTimeAndPrecursorInfo(a)
rds <- system.file("extdata", "demo.FT1.rds", package = "Aerith")
demo_file <- tempfile(fileext = ".FT1")
writeLines(readRDS(rds), demo_file)
a <- readAllScanMS1(demo_file)
b <- getRetentionTimeAndPrecursorInfo(a)
}
