% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPSMs.R
\name{getRealScans}
\alias{getRealScans}
\title{Get real scans from a scans list of one FT file with charges converted to 1 and intensities normalized by the highest peak.}
\usage{
getRealScans(ft, scanNumbers)
}
\arguments{
\item{ft}{A list of scans from one FT file.}

\item{scanNumbers}{An integer vector of scan numbers of PSMs.}
}
\value{
A list of AAspectra objects representing the real scans.
}
\description{
Get real scans from a scans list of one FT file with charges converted to 1 and intensities normalized by the highest peak.
}
\examples{
scanNumbers <- c("2596", "8182")
demo_file <- system.file("extdata", "X13_4068_2596_8182.FT2", package = "Aerith")
ft2 <- readAllScanMS2(demo_file)
realScans <- getRealScans(ft2, scanNumbers)
}
