% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distanceDyad.R
\name{distanceDyad}
\alias{distanceDyad}
\title{Distance of potential nucleosome dyad}
\usage{
distanceDyad(vPlotOut, fragLenRanges = c(60, 180, 250), draw = TRUE, ...)
}
\arguments{
\item{vPlotOut}{The output of \link{vPlot}.}

\item{fragLenRanges}{A numeric vector (length=3) for fragment size of nucleosome free and mono-nucleosome.
Default c(60, 180, 250).}

\item{draw}{Plot the results or not. Default TRUE.}

\item{...}{Prameters could be passed to plot.}
}
\value{
an invisible list with distance of nucleosome and the linear model.
}
\description{
Calculate the distance of potential nucleosome dyad and the linear model for V.
}
\examples{
bamfile <- system.file("extdata", "GL1.bam",
                       package="ATACseqQC")
library(MotifDb)
CTCF <- query(MotifDb, c("CTCF"))
CTCF <- as.list(CTCF)
library(BSgenome.Hsapiens.UCSC.hg19)
vp <- vPlot(bamfile, pfm=CTCF[[1]],
     genome=Hsapiens,
     min.score="95\%", seqlev="chr1",
     draw=FALSE)
distanceDyad(vp)
     
}
\seealso{
\link{vPlot}
}
\author{
Jianhong Ou
}
