% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_marker_signs.R
\name{compute_sepI_all}
\alias{compute_sepI_all}
\title{Compute separation indices for each cluster against the others.}
\usage{
compute_sepI_all(sce = NULL, labels = NULL, nrand_samples = NULL)
}
\arguments{
\item{sce}{A SingleCellExperiment object.}

\item{labels}{A vector of labels of all the samples (cells).}

\item{nrand_samples}{An integer for the number of samples used for
random sampling, which samples at least one sample per cluster.}
}
\value{
A SingleCellExperiment object.
}
\description{
This function computes separation indices for each cluster versus the others.
}
\examples{
data(pbmcs_eg)
labels <- SummarizedExperiment::colData(pbmcs_eg$GO)$seurat_clusters
pbmcs_eg$GO <- compute_sepI_all(sce = pbmcs_eg$GO, labels = labels,
                                nrand_samples = 10)
# The results are stored in `metadata(pbmcs_eg$GO)$marker_signs`.

}
