% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign.covergence.R
\name{assign.convergence}
\alias{assign.convergence}
\title{Check the convergence of the MCMC chain}
\usage{
assign.convergence(
  test,
  burn_in = 0,
  iter = 2000,
  parameter = c("B", "S", "Delta", "beta", "kappa", "gamma", "sigma"),
  whichGene,
  whichSample,
  whichPath
)
}
\arguments{
\item{test}{The list object returned from the assign.mcmc function. The list
components are the MCMC chains of the B, S, Delta, beta, gamma, and sigma.}

\item{burn_in}{The number of burn-in iterations. These iterations are
discarded when computing the posterior means of the model parameters. The
default is 0.}

\item{iter}{The number of total iterations. The default is 2000.}

\item{parameter}{A character string indicating which model parameter is to be
checked for convergence. This must be one of "B", "S", "Delta", "beta",
"kappa", "gamma", and "sigma".}

\item{whichGene}{A numerical value indicating which gene is to be checked
for convergence. The value has to be in the range between 1 and G.}

\item{whichSample}{A numerical value indicating which test sample is to be
checked for convergence. The value has to be in the range between 1 and N.}

\item{whichPath}{A numerical value indicating which pathway is to be checked
for convergence. The value has to be in the range between 1 and K.}
}
\value{
The assign.convergence function returns the a vector of the
estimated values from each Gibbs sampling iteration of the model parameter
to be checked, and a trace plot of this parameter.
}
\description{
The assign.convergence checks the convergence of the MCMC chain of the model
parameters generated by the Gibbs sampling algorithm.
}
\details{
To compute the convergence of the gth gene in B, set whichGene=g,
whichSample=NA, whichPath=NA.

To compute the convergence of the gth gene in the kth pathway within the
signature matrix (S), set whichGene=g, whichSample=NA, whichPath=NA.

To compute the convergence of the kth pathway in the jth test sample within
the pathway activation matrix (A), set whichGene=NA, whichSample=n,
whichPath=k.
}
\examples{

\dontrun{
# check the 10th gene in the 1st pathway for the convergence
trace.plot <- assign.convergence(test=mcmc.chain, burn_in=0, iter=2000,
                                 parameter="S", whichGene=10, whichSample=NA,
                                 whichPath=1)
}

}
\author{
Ying Shen
}
