% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{importSpectra}
\alias{importSpectra}
\title{Import metabolomic spectra}
\usage{
importSpectra(
  name.dir = NULL,
  name.file = NULL,
  type.import,
  baseline.correction = FALSE,
  alignment = FALSE,
  normalisation = TRUE,
  ncores = 1,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{name.dir}{Path of the folder containing the spectra. Each
subfolder contains the fid or the 1r (preprocessed spectrum) files of this
sample if \code{type = "fid"} or \code{type = "1r"}.}

\item{name.file}{Name of the txt or csv file containing the spectra in
columns (spectrum names in the first line and ppm grid in the first column).}

\item{type.import}{Type of import. Either \code{"txt"}, \code{"csv"},
\code{"fid"} or \code{"1r"}.}

\item{baseline.correction}{Logical. If \code{TRUE} a baseline correction is
applied for each spectrum. Default to \code{FALSE}.}

\item{alignment}{Logical. If \code{TRUE} a peak alignment is
applied between all spectra. Default to \code{FALSE}.}

\item{normalisation}{Logical. If \code{TRUE} a normalisation is applied for
each spectrum (see \code{\link{normaliseSpectra}} for details). Default to
\code{TRUE}.}

\item{ncores}{Number of cores used in parallel evaluation. Default to
\code{1}.}

\item{verbose}{A boolean value to allow print out process information.}

\item{...}{Further arguments to be passed to the functions
\code{\link{read.table}}, \code{\link{importSpectraBruker}},
\code{\link[PepsNMR]{Normalization}}
(\code{\link[PepsNMR]{PepsNMR-package}}), \code{\link{alignSpectra}} or
\code{\link{normaliseSpectra}} for
specifying the parameters of the algorithm, if necessary.}
}
\value{
A data frame with spectra in columns and chemical shifts (in ppm)
in rows.
}
\description{
Import spectra from text or CSV, fid or 1r (preprocessed spectrum) files.
(optional) Spectra are baseline corrected, aligned and normalised during the
importation.
}
\details{
Some preprocessing steps are included during the importation. First, spectra
are baseline corrected if \code{baseline.correction = TRUE}. Then, all
spectrum definition domains are aligned to a unique one (either the one
specified in \code{ppm.grid} or the grid of the default library). Finally,
all spectra are normalised if \code{normalisation = TRUE} and aligned if
\code{alignment = TRUE}.
}
\examples{
## Import from txt file
current_path <- system.file("extdata", package = "ASICS")
spectra_data <- importSpectra(name.dir = current_path,
                     name.file = "spectra_example.txt", type.import = "txt")

## Import from fid file
current_path <- system.file("extdata", "example_spectra", package = "ASICS")
spectra_data <- importSpectra(name.dir = current_path, type.import = "fid",
                             subdirs = TRUE, dirs.names = TRUE)

## Import from txt file
current_path <- system.file("extdata", "example_spectra", package = "ASICS")
spectra_data <- importSpectra(name.dir = current_path, type.import = "1r")
}
\references{
Wang, K.C., Wang, S.Y., Kuo, C.H., Tseng Y.J. (2013).
Distribution-based classification method for baseline correction of
metabolomic 1D proton nuclear magnetic resonance spectra.
\emph{Analytical Chemistry}, \strong{85}(2), 1231-1239.
}
\seealso{
\code{\link{importSpectraBruker}}
\code{\link{normaliseSpectra}} \code{\link{alignSpectra}}
}
