% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{createPureLibrary}
\alias{createPureLibrary}
\title{Create a pure library}
\usage{
createPureLibrary(spectra, nb.protons, threshold = 1)
}
\arguments{
\item{spectra}{Data frame with spectra in columns and chemical shifts in
rows. Colnames of this data frame correspond to pure metabolite names and
rownames to chemical shift grid (in ppm).}

\item{nb.protons}{Numeric vector of the number of protons for each pure
metabolite spectrum contained in \code{spectra} data frame.}

\item{threshold}{Numeric value or numeric vector of length
\code{ncol(spectra)} below which pure spectrum values are considered to be
zero. Default to 1.}
}
\value{
A \linkS4class{PureLibrary} object with the newly created library.
}
\description{
Create a new pure library from a data frame containing different spectra of
pure metabolites. The noise is removed by thresholding each spectrum during
the creation of a new pure library.
}
\examples{
pure_spectra <- importSpectraBruker(system.file("extdata",
                                                "example_library",
                                                package = "ASICS"))
new_pure_library <- createPureLibrary(pure_spectra,
                                      nb.protons = c(5, 4))

}
